/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.Passives.Shield;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.LinkedList;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.MobExtraDrawBuff;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.PacketMobResetBuffTime;
import rpgclasses.utils.RPGUtils;

public class ArcaneShield
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("20 - <skilllevel>")};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public ArcaneShield(int levelMax, int requiredClassLevel) {
        super("arcaneshield", "#6633ff", levelMax, requiredClassLevel);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new MagicShieldBuff(this.getColor(), params[0], null);
    }

    public static class MagicShieldBuff
    extends PrincipalPassiveBuff
    implements MobExtraDrawBuff {
        public GameTexture starBarrierTexture;
        public Color shieldColor;
        public SkillParam cooldownParam;
        public int cooldownNumber;
        public RPGUtils.TriRunnable<ActiveBuff, Integer, PlayerData> onPrevent;

        @Override
        public void loadTextures() {
            super.loadTextures();
            this.starBarrierTexture = GameTexture.fromFile((String)"particles/starbarrier");
        }

        public MagicShieldBuff(Color shieldColor, SkillParam cooldownParam, RPGUtils.TriRunnable<ActiveBuff, Integer, PlayerData> onPrevent) {
            this.shieldColor = shieldColor;
            this.onPrevent = onPrevent;
            this.cooldownParam = cooldownParam;
            this.cooldownNumber = 0;
        }

        public MagicShieldBuff(Color shieldColor, int cooldown, RPGUtils.TriRunnable<ActiveBuff, Integer, PlayerData> onPrevent) {
            this.shieldColor = shieldColor;
            this.onPrevent = onPrevent;
            this.cooldownParam = null;
            this.cooldownNumber = cooldown;
        }

        public MagicShieldBuff(Color shieldColor, float cooldown, RPGUtils.TriRunnable<ActiveBuff, Integer, PlayerData> onPrevent) {
            this(shieldColor, (int)(cooldown * 1000.0f), onPrevent);
        }

        public int getCooldown(ActiveBuff activeBuff) {
            return this.cooldownNumber == 0 ? (int)(this.cooldownParam.value(this.getLevel(activeBuff)) * 1000.0f) : this.cooldownNumber;
        }

        @Override
        public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
            activeBuff.getGndData().setInt("time", 50);
        }

        public void serverTick(ActiveBuff activeBuff) {
            super.serverTick(activeBuff);
            if (!activeBuff.getGndData().getBoolean("ready")) {
                int time = activeBuff.getGndData().getInt("time", 0);
                if ((time += 50) >= this.getCooldown(activeBuff)) {
                    activeBuff.getGndData().setBoolean("ready", true);
                }
                activeBuff.getGndData().setInt("time", time);
            }
        }

        public void clientTick(ActiveBuff activeBuff) {
            super.clientTick(activeBuff);
            if (!activeBuff.getGndData().getBoolean("ready")) {
                int time = activeBuff.getGndData().getInt("time", 0);
                if (time == 0) {
                    SoundManager.playSound((GameSound)GameResources.shatter2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(2.0f).pitch(0.8f));
                }
                if ((time += 50) >= this.getCooldown(activeBuff)) {
                    activeBuff.getGndData().setBoolean("ready", true);
                    SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(1.0f));
                    SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(1.0f));
                }
                activeBuff.getGndData().setInt("time", time);
            }
        }

        public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
            super.onBeforeHitCalculated(activeBuff, event);
            if (activeBuff.getGndData().getBoolean("ready") && !event.isPrevented()) {
                event.prevent();
                event.showDamageTip = false;
                event.playHitSound = false;
                PlayerMob player = (PlayerMob)activeBuff.owner;
                activeBuff.getGndData().setBoolean("ready", false);
                activeBuff.getGndData().setInt("time", 0);
                player.getServer().network.sendToClientsAtEntireLevel((Packet)new PacketMobResetBuffTime(player.getUniqueID(), activeBuff.buff.getStringID()), player.getLevel());
                if (this.onPrevent != null) {
                    this.onPrevent.run(activeBuff, this.getLevel(activeBuff), PlayerDataList.getPlayerData(player));
                }
            }
        }

        public void addBackDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        }

        public void addFrontDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (perspective == null) {
                return;
            }
            if (activeBuff.getGndData().getBoolean("ready")) {
                Rectangle selectBox = activeBuff.owner.getSelectBox(x, y);
                int size = Math.max(selectBox.width, selectBox.height);
                int modX = size - selectBox.width;
                int modY = size - selectBox.height;
                int drawX = camera.getDrawX((float)selectBox.x - (float)modX / 2.0f);
                int drawY = camera.getDrawY((float)selectBox.y - (float)modY / 2.0f);
                list.add((DrawOptions)this.starBarrierTexture.initDraw().sprite((int)(perspective.getLocalTime() / 100L) % 4, 0, 64).size(size, size).color(this.shieldColor).pos(drawX, drawY).alpha(0.6f));
            }
        }

        public void drawIcon(int x, int y, ActiveBuff activeBuff) {
            super.drawIcon(x, y, activeBuff);
            if (!activeBuff.getGndData().getBoolean("ready")) {
                int time = activeBuff.getGndData().getInt("time", 0) - 50;
                String text = EquippedActiveSkill.getTimeLeftString(this.getCooldown(activeBuff) - time);
                int width = FontManager.bit.getWidthCeil(text, durationFontOptions);
                FontManager.bit.drawString((float)(x + 28 - width), (float)(y + 30 - FontManager.bit.getHeightCeil(text, durationFontOptions)), text, durationFontOptions);
            }
        }
    }
}

