/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.Passives;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.registries.LevelEventRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.GroundEffectEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.particle.Particle;
import necesse.inventory.item.Item;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.buffs.IgnitedBuff;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class FlamingSteps
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(3.0f), SkillParam.damageParam(0.2f)};
    public static ArrayList<String> sprintBuffIDs = new ArrayList();

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public FlamingSteps(int levelMax, int requiredClassLevel) {
        super("flamingsteps", "#ff6600", levelMax, requiredClassLevel);
    }

    @Override
    public void registry() {
        super.registry();
        LevelEventRegistry.registerEvent((String)"flamingstepsevent", FlamingStepsLevelEvent.class);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new PrincipalPassiveBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                activeBuff.getGndData().setInt("time", 0);
            }

            public void clientTick(ActiveBuff activeBuff) {
                super.clientTick(activeBuff);
                this.tick(activeBuff);
            }

            public void serverTick(ActiveBuff activeBuff) {
                super.serverTick(activeBuff);
                this.tick(activeBuff);
            }

            public void tick(ActiveBuff activeBuff) {
                boolean sprinting = false;
                for (String sprintBuffID : sprintBuffIDs) {
                    if (activeBuff.owner.buffManager.hasBuff(sprintBuffID)) {
                        sprinting = true;
                        break;
                    }
                    Mob mount2 = activeBuff.owner.getMount();
                    if (mount2 == null || !mount2.buffManager.hasBuff(sprintBuffID)) continue;
                    sprinting = true;
                    break;
                }
                if (activeBuff.owner.isServer() && sprinting) {
                    FlamingStepsLevelEvent event = new FlamingStepsLevelEvent(activeBuff.owner, activeBuff.owner.getX(), activeBuff.owner.getY(), this.getLevel(activeBuff), new GameRandom((long)Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom)));
                    activeBuff.owner.getLevel().entityManager.events.addHidden((LevelEvent)event);
                    activeBuff.owner.getServer().network.sendToClientsWithEntity((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event);
                }
                this.isVisible = sprinting;
            }
        };
    }

    static {
        sprintBuffIDs.add("leatherdashersactive");
        sprintBuffIDs.add("zephyrbootsactive");
        sprintBuffIDs.add("windbootsactive");
        sprintBuffIDs.add("ghostbootsactive");
        sprintBuffIDs.add("kineticbootsactive");
    }

    public static class FlamingStepsLevelEvent
    extends GroundEffectEvent {
        protected int tickCounter;
        public int skillLevel;

        public FlamingStepsLevelEvent() {
        }

        public FlamingStepsLevelEvent(Mob owner, int x, int y, int skillLevel, GameRandom uniqueIDRandom) {
            super(owner, x, y, uniqueIDRandom);
            this.skillLevel = skillLevel;
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextInt(this.skillLevel);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.skillLevel = reader.getNextInt();
        }

        public void init() {
            super.init();
            this.tickCounter = 0;
        }

        public void clientTick() {
            super.clientTick();
            if (GameRandom.globalRandom.getChance((float)this.skillLevel * 0.1f)) {
                this.getLevel().entityManager.addParticle((float)this.x + GameRandom.globalRandom.getFloatOffset(0.0f, 16.0f), (float)this.y + GameRandom.globalRandom.getFloatOffset(0.0f, 16.0f), Particle.GType.IMPORTANT_COSMETIC).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(255, 51, 0), new Color(255, 102, 0), new Color(255, 153, 0)})).heightMoves(0.0f, GameRandom.globalRandom.getFloatBetween(16.0f, 24.0f));
            }
            ++this.tickCounter;
            if (this.tickCounter > 40) {
                this.over();
            } else {
                super.clientTick();
            }
        }

        public void serverTick() {
            super.serverTick();
            ++this.tickCounter;
            if (this.tickCounter > 40) {
                this.over();
            } else {
                super.serverTick();
            }
        }

        public void serverHit(Mob target, boolean clientSubmitted) {
            PlayerMob player = (PlayerMob)this.owner;
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            IgnitedBuff.apply(this.owner, target, params[1].value(playerData.getLevel(), this.skillLevel), params[0].value(), false);
        }

        public void clientHit(Mob mob) {
        }

        public Shape getHitBox() {
            int width = 24;
            int height = 24;
            return new Rectangle(this.x - width / 2, this.y - height / 2, width, height);
        }

        public void hitObject(LevelObjectHit hit) {
        }
    }
}

