/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import aphorea.utils.AphColors;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.Particle;
import necesse.entity.trails.LightningTrail;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGColors;
import rpgclasses.utils.RPGUtils;

public class Zap
extends CastLevelEventActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(2.0f), SkillParam.damageParam(1.0f), SkillParam.staticParam(1.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f);
    }

    public Zap(int levelMax, int requiredClassLevel) {
        super("zap", RPGColors.HEX.lighting, levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 1000;
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        return new ZapLevelEvent((Mob)player, player.x, player.y, params[1].value(playerData.getLevel(), activeSkillLevel));
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return ZapLevelEvent.class;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 8000;
    }

    public static class ZapLevelEvent
    extends MobAbilityLevelEvent
    implements Attacker {
        private int lifeTime = 0;
        public int nextHit = 0;
        public float currentX;
        public float currentY;
        public GameDamage damage;
        public int lastHit = -1;

        public ZapLevelEvent() {
        }

        public ZapLevelEvent(Mob owner, float currentX, float currentY, float damage) {
            super(owner, new GameRandom());
            this.currentX = currentX;
            this.currentY = currentY;
            this.damage = new GameDamage(damage);
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextShortUnsigned(this.lifeTime);
            writer.putNextShortUnsigned(this.nextHit);
            writer.putNextFloat(this.currentX);
            writer.putNextFloat(this.currentY);
            writer.putNextFloat(this.damage.damage);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.lifeTime = reader.getNextShortUnsigned();
            this.nextHit = reader.getNextShortUnsigned();
            this.currentX = reader.getNextFloat();
            this.currentY = reader.getNextFloat();
            this.damage = new GameDamage(reader.getNextFloat());
        }

        public void init() {
            super.init();
            this.hitsObjects = false;
            if (this.isClient()) {
                SoundManager.playSound((GameSound)RPGResources.SOUNDS.Zap, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.0f));
            }
        }

        public void clientTick() {
            super.clientTick();
            this.tick();
            this.getLevel().entityManager.addParticle(this.currentX + (float)(GameRandom.globalRandom.nextGaussian() * 4.0), this.currentY + (float)(GameRandom.globalRandom.nextGaussian() * 4.0), Particle.GType.IMPORTANT_COSMETIC).color(AphColors.lighting);
        }

        public void serverTick() {
            super.serverTick();
            this.tick();
        }

        public void tick() {
            Mob target;
            this.lifeTime += 50;
            if ((float)this.lifeTime > params[0].value() * 1000.0f) {
                this.over();
            } else if (this.lifeTime >= this.nextHit && (target = RPGUtils.findBestTarget(this.getAttackOwner(), this.currentX, this.currentY, this.lastHit == -1 ? 500 : 150, m -> this.lastHit != m.getUniqueID())) != null) {
                this.lastHit = target.getUniqueID();
                if (this.isServer()) {
                    target.isServerHit(this.damage, this.currentX, this.currentY, 10.0f, (Attacker)this.owner);
                    RPGBuffs.applyStun(target, params[2].value());
                    SoundManager.playSound((GameSound)RPGResources.SOUNDS.Zap, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)target).volume(1.0f));
                }
                if (this.isClient()) {
                    float currentPosX = this.currentX;
                    float currentPosY = this.currentY;
                    float distance = target.getDistance(this.currentX, this.currentY);
                    float finalPosX = target.x;
                    float finalPosY = target.y;
                    int divisions = 1 + (int)(distance / 30.0f);
                    float dx = finalPosX - currentPosX;
                    float dy = finalPosY - currentPosY;
                    float length = (float)Math.sqrt(dx * dx + dy * dy);
                    float ux = dx / length;
                    float uy = dy / length;
                    float vx = -uy;
                    float vy = ux;
                    LightningTrail trail = new LightningTrail(new TrailVector(currentPosX, currentPosY, 0.0f, 0.0f, GameRandom.globalRandom.getFloatBetween(8.0f, 12.0f), 14.0f), this.level, AphColors.lighting);
                    this.level.entityManager.addTrail((Trail)trail);
                    float prevX = currentPosX;
                    float prevY = currentPosY;
                    for (int i = 1; i <= divisions; ++i) {
                        float t = (float)i / (float)divisions;
                        float baseX = currentPosX + ux * (length * t);
                        float baseY = currentPosY + uy * (length * t);
                        float maxOffset = 20.0f;
                        float offset = GameRandom.globalRandom.getFloatBetween(-maxOffset, maxOffset);
                        float newX = baseX + vx * offset;
                        float newY = baseY + vy * offset;
                        if (i == divisions) {
                            newX = finalPosX;
                            newY = finalPosY;
                        }
                        trail.addNewPoint(new TrailVector(newX, newY, newX - prevX, newY - prevY, trail.thickness, 14.0f));
                        prevX = newX;
                        prevY = newY;
                    }
                }
                this.currentX = target.x;
                this.currentY = target.y;
                this.nextHit = this.lifeTime + 200;
            }
        }
    }
}

