/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import java.awt.Shape;
import java.awt.geom.Point2D;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.MovedRectangle;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;

public class Teleport
extends CastActiveSkill {
    public static SkillParam[] params = new SkillParam[0];

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(8.0f, false);
    }

    public Teleport(int levelMax, int requiredClassLevel) {
        super("teleport", "#6633cc", levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 500;
    }

    @Override
    public void castedRun(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        int newPosY;
        int newPosX;
        int lastPosY;
        int lastPosX;
        block5: {
            super.castedRun(player, playerData, activeSkillLevel, seed);
            int range = 200;
            Point2D.Float dir = Teleport.getDir((Mob)player);
            lastPosX = player.getX();
            lastPosY = player.getY();
            do {
                newPosX = player.getX() + (int)(dir.x * (float)range);
                newPosY = player.getY() + (int)(dir.y * (float)range);
                MovedRectangle moveRect = new MovedRectangle((Mob)player, player.getX(), player.getY(), newPosX, newPosY);
                if (!player.getLevel().collides((Shape)moveRect, player.getLevelCollisionFilter())) break block5;
            } while (!((float)(range -= 4) <= 0.0f));
            newPosX = player.getX();
            newPosY = player.getY();
        }
        player.setPos((float)newPosX, (float)newPosY, true);
        if (player.getLevel().isClient()) {
            if (lastPosX != newPosX || lastPosY != newPosY) {
                for (int i = 0; i < 15; ++i) {
                    player.getLevel().entityManager.addParticle((float)lastPosX + (float)GameRandom.globalRandom.nextGaussian() * 10.0f + player.dx / 2.0f, (float)lastPosY + (float)GameRandom.globalRandom.nextGaussian() * 15.0f + player.dy / 2.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(player.dx * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f, player.dy * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f).color(this.getColor()).height(18.0f).lifeTime(700);
                }
            }
            for (int i = 0; i < 15; ++i) {
                player.getLevel().entityManager.addParticle(player.x + (float)GameRandom.globalRandom.nextGaussian() * 10.0f + player.dx / 2.0f, player.y + (float)GameRandom.globalRandom.nextGaussian() * 15.0f + player.dy / 2.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(player.dx * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f, player.dy * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f).color(this.getColor()).height(18.0f).lifeTime(700);
            }
        }
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.teleport, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).volume(0.5f));
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 8000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return super.getCooldownModPerLevel() - 1200;
    }
}

