/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import rpgclasses.buffs.IgnitedBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class Inferno
extends CastActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(0.6f), SkillParam.staticParam(10.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(30.0f);
    }

    public Inferno(int levelMax, int requiredClassLevel) {
        super("inferno", "#990000", levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 2000;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunServer(player, playerData, activeSkillLevel, seed);
        float damage = params[0].value(playerData.getLevel(), activeSkillLevel);
        float time = params[1].value();
        RPGUtils.streamMobsAndPlayers((Mob)player, 200).filter(RPGUtils.isValidTargetFilter((Mob)player)).forEach(target -> IgnitedBuff.apply((Mob)player, target, damage, time, false));
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.firespell1, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.5f).pitch(0.5f));
        SoundManager.playSound((GameSound)GameResources.croneLaugh, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.5f).pitch(0.8f));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(300.0f, new Color[]{new Color(255, 51, 0), new Color(255, 102, 0), new Color(255, 153, 0)})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }
}

