/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.projectiles.FireballProjectile;
import rpgclasses.utils.RPGUtils;

public class Fireball
extends CastActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(20.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(60.0f);
    }

    public Fireball(int levelMax, int requiredClassLevel) {
        super("fireball", "#ff3300", levelMax, requiredClassLevel);
    }

    @Override
    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunServer(player, playerData, activeSkillLevel, seed);
        Projectile projectile = Fireball.getProjectile(player, playerData, activeSkillLevel);
        projectile.resetUniqueID(new GameRandom((long)seed));
        player.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
        player.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile(projectile), (RegionPositionGetter)projectile);
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.firespell1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player));
    }

    private static Projectile getProjectile(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        int distance;
        float targetY;
        float targetX;
        Mob target = RPGUtils.findBestTarget((Mob)player, 600);
        if (target == null) {
            Point2D.Float dir = Fireball.getDir((Mob)player);
            targetX = dir.x * 100.0f + player.x;
            targetY = dir.y * 100.0f + player.y;
            distance = 600;
        } else {
            targetX = target.x;
            targetY = target.y;
            distance = (int)player.getDistance(target);
        }
        return new FireballProjectile(player.getLevel(), (Mob)player, player.x, player.y, targetX, targetY, 100.0f, distance, new GameDamage(DamageTypeRegistry.MAGIC, params[0].value(playerData.getLevel(), activeSkillLevel)), 100);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"fireball"};
    }
}

