/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;
import rpgclasses.buffs.IgnitedBuff;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class FireEnchantment
extends CastBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(10.0f), new SkillParam("5 + <skilllevel>"), SkillParam.staticParam(5.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(20.0f);
    }

    public FireEnchantment(int levelMax, int requiredClassLevel) {
        super("fireenchantment", "#ff3300", levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 1000;
    }

    @Override
    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        GameUtils.streamServerClients((Level)player.getLevel()).forEach(targetPlayer -> {
            if (targetPlayer.isSameTeam(player.getTeam())) {
                super.giveBuff(player, (Mob)targetPlayer.playerMob, activeSkillLevel);
            }
        });
        RPGUtils.streamMobsAndPlayers((Mob)player, 200).filter(m -> m == player || m.isSameTeam((Mob)player)).forEach(target -> super.giveBuff(player, (Mob)target, activeSkillLevel));
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.firespell1, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(1.0f));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(200.0f, new Color[]{this.getColor()})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            public void clientTick(ActiveBuff activeBuff) {
                Mob owner = activeBuff.owner;
                if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                    owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(FireEnchantment.this.getColor()).height(16.0f);
                }
            }

            public void onHasAttacked(ActiveBuff activeBuff, MobWasHitEvent event) {
                super.onHasAttacked(activeBuff, event);
                if (event.damage > 0 && !event.wasPrevented) {
                    IgnitedBuff.apply(activeBuff.owner, event.target, (float)event.damage * params[1].value(this.getLevel(activeBuff)), params[2].value(), false);
                }
            }
        };
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 30000;
    }
}

