/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Wizard.ActiveSkills;

import java.util.ArrayList;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.summons.DancingFlameMob;

public class FireDance
extends CastBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(4.0f), SkillParam.damageParam(3.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(30.0f);
    }

    public FireDance(int levelMax, int requiredClassLevel) {
        super("firedance", "#6633cc", levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 2000;
    }

    @Override
    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunServer(player, playerData, activeSkillLevel, seed);
        for (int i = 0; i < params[0].valueInt(); ++i) {
            FireDance.summonDancingFlame(player, playerData, activeSkillLevel, this.stringID);
        }
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y));
        SoundManager.playSound((GameSound)GameResources.firespell1, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y));
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new DancingFlameBuff(this, this.stringID);
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return 20000;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"dancingflame"};
    }

    public static void summonDancingFlame(PlayerMob player, PlayerData playerData, ActiveSkill activeSkill, String skillStringID) {
        FireDance.summonDancingFlame(player, playerData, playerData.getClassesData()[activeSkill.playerClass.id].getActiveSkillLevels()[activeSkill.id], skillStringID);
    }

    public static void summonDancingFlame(PlayerMob player, PlayerData playerData, int activeSkillLevel, String skillStringID) {
        DancingFlameMob mob = (DancingFlameMob)MobRegistry.getMob((String)"dancingflame", (Level)player.getLevel());
        player.serverFollowersManager.addFollower(skillStringID, (Mob)mob, FollowPosition.FLYING_CIRCLE_FAST, null, 1.0f, 7, null, true);
        mob.updateDamage(new GameDamage(DamageTypeRegistry.MAGIC, params[1].value(playerData.getLevel(), activeSkillLevel)));
        mob.setPurple();
        mob.getLevel().entityManager.addMob((Mob)mob, player.x, player.y);
    }

    public static class DancingFlameBuff
    extends ActiveSkillBuff {
        public ActiveSkill skill;
        public String skillStringID;

        public DancingFlameBuff(ActiveSkill skill, String skillStringID) {
            this.skill = skill;
            this.skillStringID = skillStringID;
        }

        public void serverTick(ActiveBuff activeBuff) {
            int alreadySummoned = activeBuff.getGndData().getInt("alreadySummoned", 0);
            if (alreadySummoned < 3) {
                int skillTime = activeBuff.getGndData().getInt("skillTime", 50);
                activeBuff.getGndData().setInt("skillTime", skillTime += 50);
                if (skillTime / 5000 > alreadySummoned) {
                    activeBuff.getGndData().setInt("alreadySummoned", ++alreadySummoned);
                    PlayerMob player = (PlayerMob)activeBuff.owner;
                    FireDance.summonDancingFlame(player, PlayerDataList.getPlayerData(player), this.skill, this.skillStringID);
                }
            }
        }

        public void onRemoved(ActiveBuff activeBuff) {
            ArrayList mobs = new ArrayList();
            ((PlayerMob)activeBuff.owner).serverFollowersManager.streamFollowers().filter(m -> m.summonType.equals(this.skillStringID)).forEach(m -> mobs.add(m.mob));
            for (Mob mob : mobs) {
                mob.remove();
            }
        }
    }
}

