/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.particle.Particle;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Params.SkillParamColors;
import rpgclasses.utils.RPGColors;

public class Recovery
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(10.0f), new SkillParam("1 + 0.1 x <playerlevel> x <skilllevel>", SkillParamColors.HEALING)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f);
    }

    public Recovery(int levelMax, int requiredClassLevel) {
        super("recovery", "#00ff00", levelMax, requiredClassLevel);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                int level = this.getLevel(activeBuff);
                float healthRegen = params[1].value(level);
                activeBuff.setModifier(BuffModifiers.COMBAT_HEALTH_REGEN_FLAT, (Object)Float.valueOf(healthRegen));
            }

            public void clientTick(ActiveBuff activeBuff) {
                Mob owner = activeBuff.owner;
                if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                    owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(RPGColors.green).height(16.0f);
                }
            }
        };
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 24000;
    }
}

