/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.util.Objects;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class Provocation
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("2 x <skilllevel>")};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public Provocation(int levelMax, int requiredClassLevel) {
        super("provocation", "#ff0000", levelMax, requiredClassLevel);
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value(activeSkillLevel) * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 15000;
    }

    @Override
    public ActiveBuff getActiveBuff(PlayerMob player, Mob target, int activeSkillLevel) {
        ActiveBuff ab = super.getActiveBuff(player, target, activeSkillLevel);
        ab.getGndData().setString("playerTarget", player.playerName);
        return ab;
    }

    @Override
    public void giveBuffOnRun(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        RPGUtils.streamMobsAndPlayers((Mob)player, 500).filter(RPGUtils.isValidAttackerFilter((Mob)player)).filter(mob -> !mob.isPlayer).forEach(target -> super.giveBuff(player, (Mob)target, activeSkillLevel));
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.croneLaugh, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(1.0f));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(500.0f, new Color[]{this.getColor()})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                activeBuff.setModifier(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(10.0f));
            }

            public void serverTick(ActiveBuff activeBuff) {
                this.tick(activeBuff);
            }

            public void clientTick(ActiveBuff activeBuff) {
                this.tick(activeBuff);
                Mob owner = activeBuff.owner;
                if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                    owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(255, 0, 0)).height(16.0f);
                }
            }

            public void tick(ActiveBuff activeBuff) {
                PlayerMob playerTarget;
                if (activeBuff.owner.ai != null && (playerTarget = this.getPlayerTarget(activeBuff)) != null) {
                    activeBuff.owner.ai.blackboard.put((Object)"currentTarget", (Object)playerTarget);
                    activeBuff.owner.ai.blackboard.put((Object)"focusTarget", (Object)playerTarget);
                }
            }

            public PlayerMob getPlayerTarget(ActiveBuff activeBuff) {
                String playerName = activeBuff.getGndData().getString("playerTarget");
                if (playerName == null) {
                    return null;
                }
                return RPGUtils.streamPlayers(activeBuff.owner, 600).filter(player -> Objects.equals(player.playerName, playerName)).findFirst().orElse(null);
            }
        };
    }
}

