/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGColors;

public class Parry
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(0.5f), SkillParam.staticParam(500.0f).setDecimals(2, 0), SkillParam.staticParam(100.0f).setDecimals(2, 0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public Parry(int levelMax, int requiredClassLevel) {
        super("parry", RPGColors.HEX.gold, levelMax, requiredClassLevel);
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(1.2f));
        ParticleTypeSwitcher particleTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
        for (int i = 0; i < 20; ++i) {
            int angle = (int)(360.0f + GameRandom.globalRandom.nextFloat() * 360.0f);
            float dx = (float)Math.sin(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            float dy = (float)Math.cos(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            player.getLevel().entityManager.addParticle((Entity)player, particleTypeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(RPGColors.gold).heightMoves(10.0f, 30.0f).lifeTime(0);
        }
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            public void onBeforeHit(ActiveBuff activeBuff, MobBeforeHitEvent event) {
                super.onBeforeHit(activeBuff, event);
                if (!event.isPrevented() && event.damage.damage > 0.0f && activeBuff.owner.isServer() && event.attacker.getAttackOwner() != null) {
                    event.attacker.getAttackOwner().isServerHit(new GameDamage(DamageTypeRegistry.TRUE, params[1].value() * event.damage.damage), activeBuff.owner.x, activeBuff.owner.y, 100.0f, (Attacker)activeBuff.owner);
                    event.prevent();
                    event.showDamageTip = false;
                    event.playHitSound = false;
                }
            }
        };
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 8000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return -1000;
    }

    @Override
    public float consumedStaminaBase() {
        return params[2].value();
    }
}

