/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import java.awt.Point;
import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.projectile.Projectile;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import org.jetbrains.annotations.NotNull;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.projectiles.ObjectProjectile;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGColors;

public class ObjectThrowing
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(20.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public ObjectThrowing(int levelMax, int requiredClassLevel) {
        super("objectthrowing", RPGColors.HEX.iron, levelMax, requiredClassLevel);
    }

    @Override
    public void run(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUSe) {
        super.run(player, playerData, activeSkillLevel, seed, isInUSe);
        if (isInUSe) {
            if (playerData.grabbedObject != null) {
                if (player.isServer()) {
                    Projectile projectile = ObjectThrowing.getProjectile(player, playerData, activeSkillLevel);
                    projectile.resetUniqueID(new GameRandom((long)seed));
                    player.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
                    player.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile(projectile), (RegionPositionGetter)projectile);
                }
                playerData.grabbedObject = null;
            }
            player.buffManager.removeBuff((Buff)RPGBuffs.PASSIVES.GRABBED_OBJECT, player.isServer());
        } else {
            Point objectPoint = this.getObject(player);
            if (objectPoint == null) {
                for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                    if (equippedActiveSkill.getActiveSkill() != this) continue;
                    equippedActiveSkill.restartCooldown();
                }
                return;
            }
            playerData.grabbedObject = player.getLevel().getObject(objectPoint.x, objectPoint.y);
            player.getLevel().setObject(objectPoint.x, objectPoint.y, 0);
            player.buffManager.addBuff(new ActiveBuff((Buff)RPGBuffs.PASSIVES.GRABBED_OBJECT, (Mob)player, 1000, null), player.isServer());
        }
    }

    @NotNull
    private static Projectile getProjectile(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        Point2D.Float dir = ObjectThrowing.getDir((Mob)player);
        float targetX = dir.x * 100.0f + player.x;
        float targetY = dir.y * 100.0f + player.y;
        return new ObjectProjectile(player.getLevel(), (Mob)player, playerData.grabbedObject, player.x, player.y, targetX, targetY, 100.0f, 500, new GameDamage(DamageTypeRegistry.MELEE, params[0].value(playerData.getLevel(), activeSkillLevel)), 300);
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        String canActive = super.canActive(player, playerData, activeSkillLevel, isInUSe);
        if (canActive != null) {
            return canActive;
        }
        if (isInUSe) {
            return null;
        }
        return this.getObject(player) == null ? "nograbbableobject" : null;
    }

    public Point getObject(PlayerMob player) {
        int tileY;
        Level level = player.getLevel();
        if (level.isProtected) {
            return null;
        }
        int tileX = player.getTileX();
        GameObject object = PlayerData.isGrabbableObject(level, tileX, tileY = player.getTileY());
        if (object != null) {
            return new Point(tileX, tileY);
        }
        if (player.getDir() == 0) {
            --tileY;
        } else if (player.getDir() == 1) {
            ++tileX;
        } else if (player.getDir() == 2) {
            ++tileY;
        } else if (player.getDir() == 3) {
            --tileX;
        }
        object = PlayerData.isGrabbableObject(level, tileX, tileY);
        return object == null ? null : new Point(tileX, tileY);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 16000;
    }

    @Override
    public boolean isInUseSkill() {
        return true;
    }
}

