/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.CompositeAINode;
import necesse.entity.mobs.ai.behaviourTree.CompositeTypedAINode;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.mobs.ai.RunningAwayAI;
import rpgclasses.utils.RPGUtils;

public class Intimidation
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("<skilllevel>")};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public Intimidation(int levelMax, int requiredClassLevel) {
        super("intimidation", "#9900cc", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value(activeSkillLevel) * 1000.0f);
    }

    @Override
    public void giveBuffOnRun(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        RPGUtils.streamMobsAndPlayers((Mob)player, 300).filter(m -> !m.isBoss()).filter(RPGUtils.isValidTargetFilter((Mob)player)).forEach(target -> super.giveBuff(player, (Mob)target, activeSkillLevel));
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(0.5f));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(300.0f, new Color[]{this.getColor()})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                super.init(activeBuff, buffEventSubscriber);
                if (activeBuff.owner.ai.tree instanceof CompositeAINode) {
                    CompositeAINode aiNode = (CompositeAINode)activeBuff.owner.ai.tree;
                    RunningAwayAI runFromMobsAI = new RunningAwayAI(1000, m -> m.isPlayer);
                    aiNode.addChildFirst(runFromMobsAI);
                    try {
                        Field childrenField = CompositeTypedAINode.class.getDeclaredField("runningNode");
                        childrenField.setAccessible(true);
                        childrenField.set(aiNode, (Object)runFromMobsAI);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    activeBuff.setModifier(BuffModifiers.INTIMIDATED, (Object)true);
                    activeBuff.setModifier(BuffModifiers.SPEED, (Object)Float.valueOf(1.0f));
                }
            }

            public void clientTick(ActiveBuff activeBuff) {
                Mob owner = activeBuff.owner;
                if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                    owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(153, 0, 204)).height(16.0f);
                }
            }

            public void onRemoved(ActiveBuff activeBuff) {
                super.onRemoved(activeBuff);
                if (activeBuff.owner.ai.tree instanceof CompositeAINode) {
                    CompositeAINode aiNode = (CompositeAINode)activeBuff.owner.ai.tree;
                    try {
                        Field childrenField = CompositeTypedAINode.class.getDeclaredField("children");
                        childrenField.setAccessible(true);
                        ArrayList children = (ArrayList)childrenField.get(aiNode);
                        children.remove(0);
                        childrenField.set(aiNode, children);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }
}

