/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills.Ground;

import aphorea.registry.AphBuffs;
import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGColors;

public class GroundDestruction
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(6.0f), SkillParam.staticParam(2.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public GroundDestruction(int levelMax, int requiredClassLevel) {
        super("grounddestruction", "#cc3E2B", levelMax, requiredClassLevel);
    }

    @Override
    public void run(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        Color debrisColor;
        super.run(player, playerData, activeSkillLevel, seed, isInUse);
        ActiveBuff ab = new ActiveBuff(AphBuffs.STOP, (Mob)player, 300, null);
        player.buffManager.addBuff(ab, false);
        Color colorArea = RPGColors.dirt;
        if (player.isClient() && (debrisColor = player.getLevel().getTile(player.getTileX(), player.getTileY()).getDebrisColor(player.getLevel(), player.getTileX(), player.getTileY())) != null) {
            colorArea = debrisColor;
        }
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(120.0f, new Color[]{colorArea, RPGColors.dirt, RPGColors.red}).setDebuffArea((int)(params[1].value() * 1000.0f), new String[]{AphBuffs.STUN.getStringID()}).setDamageArea(new GameDamage(DamageTypeRegistry.MELEE, params[0].value(playerData.getLevel(), activeSkillLevel)))});
        areaList.execute((Mob)player, false);
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.punch, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(0.5f));
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(0.5f));
        player.getClient().startCameraShake(player.x, player.y, 300, 40, 3.0f, 3.0f, true);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 16000;
    }
}

