/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Warrior.ActiveSkills;

import aphorea.registry.AphBuffs;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LineHitbox;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobDashLevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;

public class BerserkerCharge
extends SimpleLevelEventActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(10.0f), SkillParam.staticParam(50.0f).setDecimals(2, 0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public BerserkerCharge(int levelMax, int requiredClassLevel) {
        super("berserkercharge", "#ff6600", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 14000;
    }

    @Override
    public float consumedStaminaBase() {
        return params[1].value();
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        Point2D.Float dir = BerserkerCharge.getDir((Mob)player);
        return new BerserkerChargeLevelEvent((Mob)player, seed, dir.x, dir.y, 200.0f, 200, new GameDamage(DamageTypeRegistry.MELEE, params[0].value(playerData.getLevel(), activeSkillLevel)));
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return BerserkerChargeLevelEvent.class;
    }

    public static class BerserkerChargeLevelEvent
    extends MobDashLevelEvent {
        public BerserkerChargeLevelEvent() {
        }

        public BerserkerChargeLevelEvent(Mob owner, int seed, float dirX, float dirY, float distance, int animTime, GameDamage damage) {
            super(owner, seed, dirX, dirY, distance, animTime, damage);
        }

        public void init() {
            super.init();
            if (this.level != null && this.level.isClient() && this.owner != null) {
                float forceMod = Math.min((float)this.animTime / 700.0f, 1.0f);
                float forceX = this.dirX * this.distance * forceMod;
                float forceY = this.dirY * this.distance * forceMod;
                for (int i = 0; i < 30; ++i) {
                    this.level.entityManager.addParticle(this.owner.x + (float)GameRandom.globalRandom.nextGaussian() * 15.0f + forceX / 5.0f, this.owner.y + (float)GameRandom.globalRandom.nextGaussian() * 20.0f + forceY / 5.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(forceX * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f, forceY * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(255, 102, 102), new Color(204, 255, 255)})).height(18.0f).lifeTime(700);
                }
                SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(0.2f).pitch(2.5f));
            }
            if (this.owner != null) {
                this.owner.buffManager.addBuff(new ActiveBuff(BuffRegistry.INVULNERABLE_ACTIVE, this.owner, this.animTime, null), false);
                this.owner.addBuff(new ActiveBuff(AphBuffs.SABER_DASH_ACTIVE, this.owner, this.animTime, null), false);
            }
        }

        public Shape getHitBox() {
            Point2D.Float dir = this.owner.getDir() == 3 ? GameMath.getPerpendicularDir((float)(-this.dirX), (float)(-this.dirY)) : GameMath.getPerpendicularDir((float)this.dirX, (float)this.dirY);
            float width = 40.0f;
            float frontOffset = 60.0f;
            float range = 40.0f;
            float rangeOffset = -30.0f;
            return new LineHitbox(this.owner.x + dir.x * rangeOffset + this.dirX * frontOffset, this.owner.y + dir.y * rangeOffset + this.dirY * frontOffset, dir.x, dir.y, range, width);
        }
    }
}

