/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Ranger.ActiveSkills;

import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import org.jetbrains.annotations.NotNull;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.projectiles.LethalArrowProjectile;
import rpgclasses.utils.RPGUtils;

public class LethalShot
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(6.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public LethalShot(int levelMax, int requiredClassLevel) {
        super("lethalshot", "#ff0000", levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        Projectile projectile = LethalShot.getProjectile(player, playerData, activeSkillLevel);
        projectile.resetUniqueID(new GameRandom((long)seed));
        player.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
        player.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile(projectile), (RegionPositionGetter)projectile);
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.bow, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player));
    }

    @NotNull
    private static Projectile getProjectile(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        float targetY;
        float targetX;
        Mob target = RPGUtils.findBestTarget((Mob)player, 1000);
        if (target == null) {
            Point2D.Float dir = LethalShot.getDir((Mob)player);
            targetX = dir.x * 100.0f + player.x;
            targetY = dir.y * 100.0f + player.y;
        } else {
            targetX = target.x;
            targetY = target.y;
        }
        return new LethalArrowProjectile(player.getLevel(), (Mob)player, player.x, player.y, targetX, targetY, 200.0f, 1000, new GameDamage(DamageTypeRegistry.RANGED, params[0].value(playerData.getLevel(), activeSkillLevel)), 100);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 15000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"lethalarrow"};
    }
}

