/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Ranger.ActiveSkills;

import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.particle.Particle;
import rpgclasses.buffs.Interfaces.DodgeClassBuff;
import rpgclasses.buffs.MarkedBuff;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.registry.RPGModifiers;
import rpgclasses.utils.RPGColors;

public class HuntersInstinct
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(12.0f), new SkillParam("5 x <skilllevel>").setDecimals(2, 0), SkillParam.staticParam(5.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public HuntersInstinct(int levelMax, int requiredClassLevel) {
        super("huntersinstinct", "#ff0000", levelMax, requiredClassLevel);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new HuntersInstinctBuff();
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 26000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"dodgechance", "marked"};
    }

    public static class HuntersInstinctBuff
    extends ActiveSkillBuff
    implements DodgeClassBuff {
        @Override
        public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
            int level = this.getLevel(activeBuff);
            activeBuff.setModifier(RPGModifiers.DODGE_CHANCE, (Object)Float.valueOf(params[1].value(this.getLevel(activeBuff))));
        }

        public void clientTick(ActiveBuff activeBuff) {
            Mob owner = activeBuff.owner;
            if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(RPGColors.red).height(16.0f);
            }
        }

        @Override
        public void onDodge(ActiveBuff activeBuff, MobBeforeHitEvent event) {
            Mob attacker = event.attacker.getFirstAttackOwner();
            if (attacker != null) {
                MarkedBuff.markMob((PlayerMob)activeBuff.owner, attacker, params[2].value());
            }
        }
    }
}

