/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Ranger.ActiveSkills.Dash;

import java.awt.geom.Point2D;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;

public class LongDash
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(25.0f).setDecimals(2, 0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public LongDash(int levelMax, int requiredClassLevel) {
        super("longdash", "#99ff99", levelMax, requiredClassLevel);
    }

    @Override
    public void run(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUSe) {
        super.run(player, playerData, activeSkillLevel, seed, isInUSe);
        player.buffManager.addBuff(new ActiveBuff(BuffRegistry.FOW_ACTIVE, (Mob)player, 0.15f, null), false);
        player.buffManager.forceUpdateBuffs();
        Point2D.Float dir = LongDash.getDir((Mob)player);
        int strength = 150;
        float forceX = dir.x * (float)strength;
        float forceY = dir.y * (float)strength;
        if (Math.abs(player.dx) < Math.abs(forceX)) {
            player.dx = forceX;
        }
        if (Math.abs(player.dy) < Math.abs(forceY)) {
            player.dy = forceY;
        }
        if (player.isClient() && player.getLevel() != null) {
            for (int i = 0; i < 30; ++i) {
                player.getLevel().entityManager.addParticle(player.x + (float)GameRandom.globalRandom.nextGaussian() * 15.0f + forceX / 10.0f, player.y + (float)GameRandom.globalRandom.nextGaussian() * 20.0f + forceY / 10.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(forceX * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f, forceY * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f).color(this.getColor()).height(18.0f).lifeTime(700);
            }
        }
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).volume(0.35f).pitch(1.7f));
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 6000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return super.getCooldownModPerLevel() - 1000;
    }

    @Override
    public float consumedStamina(PlayerMob player) {
        return params[0].value();
    }
}

