/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Ranger.ActiveSkills;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.HitboxEffectEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGColors;

public class BearTrap
extends SimpleLevelEventActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(20.0f), SkillParam.damageParam(5.0f), SkillParam.staticParam(5.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public BearTrap(int levelMax, int requiredClassLevel) {
        super("beartrap", RPGColors.HEX.iron, levelMax, requiredClassLevel);
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        return new BearTrapLevelEvent((Mob)player, player.x, player.y, params[1].value(playerData.getLevel(), activeSkillLevel));
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return BearTrapLevelEvent.class;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 30000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return -3000;
    }

    public static class BearTrapLevelEvent
    extends HitboxEffectEvent
    implements Attacker {
        private int lifeTime = 0;
        private int trappedLifeTime = 0;
        private boolean trappedMob = false;
        private boolean ready = false;
        public float targetX;
        public float targetY;
        public GameDamage damage;
        public BearTrapParticle bearTrapParticle;

        public BearTrapLevelEvent() {
        }

        public BearTrapLevelEvent(Mob owner, float targetX, float targetY, float damage) {
            super(owner, new GameRandom());
            this.targetX = targetX;
            this.targetY = targetY;
            this.damage = new GameDamage(damage);
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextShortUnsigned(this.lifeTime);
            writer.putNextShortUnsigned(this.trappedLifeTime);
            writer.putNextBoolean(this.trappedMob);
            writer.putNextBoolean(this.ready);
            writer.putNextFloat(this.targetX);
            writer.putNextFloat(this.targetY);
            writer.putNextFloat(this.damage.damage);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.lifeTime = reader.getNextShortUnsigned();
            this.trappedLifeTime = reader.getNextShortUnsigned();
            this.trappedMob = reader.getNextBoolean();
            this.ready = reader.getNextBoolean();
            this.targetX = reader.getNextFloat();
            this.targetY = reader.getNextFloat();
            this.damage = new GameDamage(reader.getNextFloat());
        }

        public void init() {
            super.init();
            this.hitsObjects = false;
            if (this.isClient()) {
                this.bearTrapParticle = new BearTrapParticle(this.level, this.targetX, this.targetY, 20000L);
                this.level.entityManager.addParticle((Particle)this.bearTrapParticle, Particle.GType.CRITICAL);
                SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.0f));
            }
        }

        public void clientTick() {
            super.clientTick();
            if (this.trappedMob) {
                this.trappedLifeTime += 50;
                if (this.trappedLifeTime >= (int)(params[0].value() * 1000.0f)) {
                    this.over();
                    this.bearTrapParticle.remove();
                }
            } else {
                this.lifeTime += 50;
                if (this.lifeTime >= 500 && !this.ready) {
                    this.ready = true;
                    this.bearTrapParticle.setOpen(true);
                    SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.0f));
                } else if (this.lifeTime >= 20000) {
                    this.over();
                    this.bearTrapParticle.remove();
                }
            }
        }

        public void serverTick() {
            super.serverTick();
            if (this.trappedMob) {
                this.trappedLifeTime += 50;
                if (this.trappedLifeTime >= (int)(params[0].value() * 1000.0f)) {
                    this.over();
                }
            } else {
                this.lifeTime += 50;
                if (this.lifeTime >= 500 && !this.ready) {
                    this.ready = true;
                } else if (this.lifeTime >= 20000) {
                    this.over();
                }
            }
        }

        public Shape getHitBox() {
            if (this.trappedMob) {
                return new Rectangle();
            }
            int size = 20;
            return new Rectangle((int)(this.targetX - (float)size / 2.0f), (int)(this.targetY - (float)size / 2.0f), size, size);
        }

        public boolean canHit(Mob mob) {
            return super.canHit(mob);
        }

        public void serverHit(Mob target, boolean clientSubmitted) {
            if (!this.trappedMob && this.ready) {
                target.isServerHit(this.damage, target.x - this.targetX, target.y - this.targetY, 0.0f, (Attacker)this.owner);
                target.addBuff(new ActiveBuff(RPGBuffs.TRAPPED, target, params[2].value(), (Attacker)this), true);
                this.trappedMob = true;
                target.setPos(this.targetX, this.targetY, true);
            }
        }

        public void clientHit(Mob mob) {
            if (!this.trappedMob && this.ready) {
                SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.0f));
                this.trappedMob = true;
                this.bearTrapParticle.setOpen(false);
                mob.setPos(this.targetX, this.targetY, true);
            }
        }

        public void hitObject(LevelObjectHit hit) {
        }
    }

    public static class BearTrapParticle
    extends Particle {
        public static int MOVE_Y = 2;
        public boolean isOpen = false;

        public BearTrapParticle(Level level, float x, float y, long lifeTime) {
            super(level, x, y + (float)MOVE_Y, lifeTime);
        }

        public void setOpen(boolean isOpen) {
            this.isOpen = isOpen;
        }

        public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (!this.removed()) {
                GameTexture texture = this.isOpen ? RPGResources.PARTICLE_TEXTURES.bearTrapOpen : RPGResources.PARTICLE_TEXTURES.bearTrapClosed;
                GameLight light = level.getLightLevel((Entity)this);
                int drawX = camera.getDrawX(this.x) - texture.getWidth() / 2;
                int drawY = camera.getDrawY(this.y) - texture.getHeight() + 11 - MOVE_Y;
                TextureDrawOptionsEnd options = texture.initDraw().light(light).pos(drawX, drawY);
                list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                    final /* synthetic */ TextureDrawOptions val$options;
                    {
                        this.val$options = textureDrawOptions;
                        super(arg0);
                    }

                    public void draw(TickManager tickManager) {
                        this.val$options.draw();
                    }
                });
            }
        }
    }
}

