/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Ranger.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import org.jetbrains.annotations.NotNull;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class ArrowStorm
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(3.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public ArrowStorm(int levelMax, int requiredClassLevel) {
        super("arrowstorm", "#009900", levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        RPGUtils.streamMobsAndPlayers((Mob)player, 400).filter(RPGUtils.isValidTargetFilter((Mob)player)).forEach(target -> {
            Projectile projectile = ArrowStorm.getProjectile(player, target, playerData, activeSkillLevel);
            projectile.resetUniqueID(new GameRandom((long)seed));
            player.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
            player.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile(projectile), (RegionPositionGetter)projectile);
        });
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        return RPGUtils.anyTarget((Mob)player, 400) ? null : "notarget";
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.bow, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(400.0f, new Color[]{this.getColor()})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }

    @NotNull
    private static Projectile getProjectile(PlayerMob player, Mob target, PlayerData playerData, int activeSkillLevel) {
        return ProjectileRegistry.getProjectile((String)"stonearrow", (Level)player.getLevel(), (float)player.x, (float)player.y, (float)target.x, (float)target.y, (float)200.0f, (int)1000, (GameDamage)new GameDamage(DamageTypeRegistry.RANGED, params[0].value(playerData.getLevel(), activeSkillLevel)), (int)100, (Mob)player);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 15000;
    }
}

