/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Necromancer.Passives;

import java.awt.Point;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketLifelineEvent;
import necesse.engine.network.packet.PacketMobMount;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.seasons.SeasonalHat;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.ActiveMountAbility;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeDamageOverTimeTakenEvent;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.event.AIEvent;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.projectile.AncientBoneProjectile;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.inventory.item.armorItem.ArmorItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.buffs.Skill.SecondaryPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;

public class Lichborn
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("10 x <skilllevel>").setDecimals(2, 0), new SkillParam("120 - 6 x <skilllevel>"), SkillParam.staticParam(100.0f).setDecimals(2, 0), SkillParam.damageParam(2.0f), SkillParam.staticParam(2.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public Lichborn(int levelMax, int requiredClassLevel) {
        super("lichborn", "#6600ff", levelMax, requiredClassLevel);
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"necromancerlich"};
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new PrincipalPassiveBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
                this.isVisible = false;
                eventSubscriber.subscribeEvent(MobBeforeDamageOverTimeTakenEvent.class, event -> {
                    if (this.runLogic(activeBuff, event.getExpectedHealth())) {
                        event.prevent();
                    }
                });
            }

            public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
                super.onBeforeHitCalculated(activeBuff, event);
                if (this.runLogic(activeBuff, event.getExpectedHealth())) {
                    event.prevent();
                }
            }

            private boolean runLogic(ActiveBuff activeBuff, int expectedHealth) {
                Level level = activeBuff.owner.getLevel();
                if (level.isServer() && expectedHealth <= 0) {
                    Mob mount2 = activeBuff.owner.getMount();
                    if (mount2 instanceof LichSkeletonMob || activeBuff.owner.buffManager.hasBuff(Lichborn.this.getSecondaryBuffStringID())) {
                        return false;
                    }
                    int skillLevel = this.getLevel(activeBuff);
                    activeBuff.owner.setHealth((int)((float)activeBuff.owner.getMaxHealth() * params[0].value(skillLevel)));
                    Lichborn.this.giveDatalessSecondaryPassiveBuff(activeBuff.owner, params[1].value(skillLevel));
                    level.getServer().network.sendToClientsWithEntity((Packet)new PacketLifelineEvent(activeBuff.owner.getUniqueID()), (RegionPositionGetter)activeBuff.owner);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public SecondaryPassiveBuff getSecondaryBuff() {
        return new SecondaryPassiveBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
                Mob owner = activeBuff.owner;
                Level level = owner.getLevel();
                if (owner.isServer()) {
                    if (owner.isMounted()) {
                        return;
                    }
                    Mob mount2 = owner.getMount();
                    if (mount2 instanceof LichSkeletonMob) {
                        this.refreshDurationOnExistingSkeleton((LichSkeletonMob)mount2, activeBuff.getDurationLeft());
                    } else {
                        this.spawnAndSetNewSkeleton(level, owner, activeBuff.getDurationLeft());
                    }
                }
                float damageAdd = params[2].value();
                new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.0f + damageAdd)).min((Object)Float.valueOf(1.0f + damageAdd)).apply((ModifierContainer)activeBuff);
            }

            private void refreshDurationOnExistingSkeleton(LichSkeletonMob mount2, int duration) {
                mount2.removeAtTime = mount2.getTime() + (long)duration;
            }

            private void spawnAndSetNewSkeleton(Level level, Mob target, int duration) {
                LichSkeletonMob lichSkeletonMob = (LichSkeletonMob)MobRegistry.getMob((String)"lichskeletonmob", (Level)level);
                lichSkeletonMob.applyData(Lichborn.this.playerClass, Lichborn.this);
                lichSkeletonMob.removeAtTime = level.getTime() + (long)duration;
                lichSkeletonMob.setPos(target.x, target.y, true);
                lichSkeletonMob.dx = target.dx;
                lichSkeletonMob.dy = target.dy;
                target.mount((Mob)lichSkeletonMob, true, target.x, target.y, true);
                level.entityManager.mobs.add((Entity)lichSkeletonMob);
                level.getServer().network.sendToClientsWithEntity((Packet)new PacketMobMount(target.getUniqueID(), lichSkeletonMob.getUniqueID(), true, target.x, target.y), (RegionPositionGetter)target);
            }
        };
    }

    @Override
    public void registry() {
        super.registry();
        MobRegistry.registerMob((String)"lichskeletonmob", LichSkeletonMob.class, (boolean)false);
    }

    public static class LichSkeletonMob
    extends SkillTransformationMountMob
    implements ActiveMountAbility {
        public long removeAtTime;
        protected SeasonalHat hat;

        public LichSkeletonMob() {
            this.setKnockbackModifier(0.4f);
        }

        @Override
        public void addSaveData(SaveData save) {
            super.addSaveData(save);
            save.addLong("removeAtTime", this.removeAtTime);
        }

        @Override
        public void applyLoadData(LoadData save) {
            super.applyLoadData(save);
            this.removeAtTime = save.getLong("removeAtTime");
        }

        @Override
        public void serverTick() {
            super.serverTick();
            if (this.getTime() <= this.removeAtTime && this.isMounted()) {
                Mob rider = this.getRider();
                if (rider != null && !rider.buffManager.hasBuff("lichborn2passivebuff")) {
                    this.remove();
                }
            } else {
                Mob rider = this.getRider();
                if (rider != null && !rider.isPlayer && rider.ai != null) {
                    rider.ai.blackboard.mover.stopMoving(rider);
                    rider.ai.blackboard.submitEvent("resetPathTime", new AIEvent());
                }
                this.remove();
            }
        }

        public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            if (this.isMounted()) {
                GameLight light = level.getLightLevel(x / 32, y / 32);
                int drawX = camera.getDrawX(x) - 22 - 10;
                int drawY = camera.getDrawY(y) - 44 - 7;
                int dir = this.getDir();
                Point sprite = this.getAnimSprite(x, y, dir);
                drawY += this.getBobbing(x, y);
                drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
                MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
                HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, MobRegistry.Textures.ancientSkeleton).sprite(sprite).dir(dir).mask(swimMask).light(light);
                if (this.hat != null) {
                    humanDrawOptions.hatTexture(this.hat.getDrawOptions(), ArmorItem.HairDrawMode.NO_HAIR);
                }
                final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
                list.add(new MobDrawable(){

                    public void draw(TickManager tickManager) {
                        drawOptions.draw();
                    }
                });
                this.addShadowDrawables(tileList, level, x, y, light, camera);
            }
        }

        public int getRockSpeed() {
            return 20;
        }

        @Override
        public void clickRunClient(Level level, int x, int y, PlayerMob player) {
            super.clickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.7f).pitch(1.2f));
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            AncientBoneProjectile projectile = new AncientBoneProjectile(player.x, player.y, (float)x, (float)y, new GameDamage(DamageTypeRegistry.MAGIC, params[3].value(playerData.getLevel(), this.getActualSkillLevel())), (Mob)player);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(params[4].value()));
            projectile.resetUniqueID(new GameRandom((long)Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom)));
            player.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
            player.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }

        @Override
        public int clickCooldown() {
            return 1000;
        }
    }
}

