/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Necromancer.ActiveSkills;

import java.awt.Color;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.buffs.MagicPoisonBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGUtils;

public class UnholyGround
extends SimpleLevelEventActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(10.0f), SkillParam.damageParam(0.8f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(15.0f);
    }

    public UnholyGround(int levelMax, int requiredClassLevel) {
        super("unholyground", "#6633ff", levelMax, requiredClassLevel);
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        return new UnholyGroundLevelEvent((Mob)player, (float)playerData.getLevel() + playerData.getIntelligence(player) * (float)activeSkillLevel - playerData.getGrace(player));
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return UnholyGroundLevelEvent.class;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 60000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"constrained"};
    }

    public static class UnholyGroundLevelEvent
    extends MobAbilityLevelEvent
    implements Attacker {
        private int lifeTime = 0;
        public int nextHit = 0;
        public float poisonDamage;
        public static int maxRange = 400;

        public UnholyGroundLevelEvent() {
        }

        public UnholyGroundLevelEvent(Mob owner, float poisonDamage) {
            super(owner, new GameRandom());
            this.poisonDamage = poisonDamage;
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextShortUnsigned(this.lifeTime);
            writer.putNextShortUnsigned(this.nextHit);
            writer.putNextFloat(this.poisonDamage);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.lifeTime = reader.getNextShortUnsigned();
            this.nextHit = reader.getNextShortUnsigned();
            this.poisonDamage = reader.getNextFloat();
        }

        public void init() {
            super.init();
            this.hitsObjects = false;
            if (this.isClient()) {
                SoundManager.playSound((GameSound)GameResources.croneLaugh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(1.5f));
            }
        }

        public void clientTick() {
            super.clientTick();
            this.tick();
        }

        public void serverTick() {
            super.serverTick();
            this.tick();
        }

        public void tick() {
            this.lifeTime += 50;
            int range = 0;
            if (this.lifeTime < 2000) {
                range = (int)((float)maxRange * ((float)this.lifeTime / 2000.0f));
            } else if (this.lifeTime <= 8000) {
                range = maxRange;
            } else if (this.lifeTime <= 10000) {
                range = (int)((float)maxRange * (1.0f - (float)(this.lifeTime - 8000) / 2000.0f));
            } else {
                this.over();
            }
            if (range > 0) {
                if (this.isServer()) {
                    RPGUtils.getAllTargets(this.owner, range, null).forEach(mob -> {
                        mob.buffManager.addBuff(new ActiveBuff(RPGBuffs.CONSTRAINED, mob, 100, null), true);
                        MagicPoisonBuff.apply(this.owner, mob, this.poisonDamage, 1000);
                    });
                } else if (this.isClient()) {
                    int particleCount = (int)((double)(range * range) * 0.002);
                    for (int i = 0; i < particleCount; ++i) {
                        float angle = GameRandom.globalRandom.getFloatBetween(0.0f, 360.0f);
                        float radius = (float)Math.sqrt(GameRandom.globalRandom.nextFloat()) * (float)range;
                        float px = this.owner.x + GameMath.cos((float)angle) * radius;
                        float py = this.owner.y + GameMath.sin((float)angle) * radius;
                        if (!RPGUtils.isInVision(this.owner.getLevel(), px, py, this.owner)) continue;
                        this.getLevel().entityManager.addParticle(px, py, Particle.GType.IMPORTANT_COSMETIC).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(51, 0, 204), new Color(102, 0, 255), new Color(102, 51, 255)})).heightMoves(0.0f, GameRandom.globalRandom.getFloatBetween(16.0f, 24.0f));
                    }
                }
            }
        }
    }
}

