/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Necromancer.ActiveSkills;

import java.awt.geom.Point2D;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.CastActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.mobs.summons.damageable.DamageableFollowingMob;

public class SkeletonWarrior
extends CastActiveSkill {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("40 x <skilllevel>").setDecimals(2, 0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f);
    }

    public SkeletonWarrior(int levelMax, int requiredClassLevel) {
        super("skeletonwarrior", "#6633ff", levelMax, requiredClassLevel);
    }

    @Override
    public int castTime() {
        return 1500;
    }

    @Override
    public void castedRunServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunServer(player, playerData, activeSkillLevel, seed);
        DamageableFollowingMob mob = (DamageableFollowingMob)MobRegistry.getMob((String)"necromancerskeletonwarrior", (Level)player.getLevel());
        player.serverFollowersManager.addFollower(this.stringID, (Mob)mob, FollowPosition.WALK_CLOSE, null, 1.0f, Integer.MAX_VALUE, null, true);
        mob.updateStats(player, playerData, 1.0f + params[0].value(activeSkillLevel));
        Point2D.Float target = SkeletonWarrior.getRandomClosePlace(player);
        player.getLevel().entityManager.addMob((Mob)mob, target.x, target.y);
    }

    @Override
    public void castedRunClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed) {
        super.castedRunClient(player, playerData, activeSkillLevel, seed);
        SoundManager.playSound((GameSound)GameResources.crack, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(0.5f));
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 30000;
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"necromancerskeletonwarrior"};
    }
}

