/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Necromancer.ActiveSkills;

import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobHealthChangeEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class Sacrifice
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("20 x <skilllevel>").setDecimals(2, 0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(5.0f);
    }

    public Sacrifice(int levelMax, int requiredClassLevel) {
        super("sacrifice", "#990000", levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        Mob sacrifice = RPGUtils.findClosestDamageableFollower((Mob)player, 1024, RPGUtils.isNecroticFollowerFilter((Mob)player));
        if (sacrifice != null) {
            sacrifice.remove(0.0f, 0.0f, null, true);
            int healing = (int)(params[0].value(activeSkillLevel) * (float)player.getMaxHealth());
            if (healing > 0) {
                player.getLevel().entityManager.events.add((LevelEvent)new MobHealthChangeEvent((Mob)player, healing));
            }
        }
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        return RPGUtils.anyDamageableFollower((Mob)player, 1024, RPGUtils.isNecroticFollowerFilter((Mob)player)) ? null : "notargetfollower";
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.crack, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(0.5f));
        SoundManager.playSound((GameSound)GameResources.croneLaugh, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(0.5f).pitch(0.5f));
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 26000;
    }
}

