/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.Passives;

import necesse.engine.network.Packet;
import necesse.entity.mobs.MobBeforeDamageOverTimeTakenEvent;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.level.maps.Level;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.UpdateClientEquippedActiveSkillsPacket;

public class PhoenixSpirit
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(4.0f).setDecimals(0), new SkillParam("4 + 8 + <skilllevel>").setDecimals(2, 0), new SkillParam("0.25 x <skilllevel>").setDecimals(0).roundFloor()};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public PhoenixSpirit(int levelMax, int requiredClassLevel) {
        super("phoenixspirit", "#ff3300", levelMax, requiredClassLevel);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new PrincipalPassiveBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
                int level = this.getLevel(activeBuff);
                if (level >= params[0].valueInt()) {
                    this.isVisible = false;
                    eventSubscriber.subscribeEvent(MobBeforeDamageOverTimeTakenEvent.class, event -> {
                        if (this.runLogic(activeBuff, level, event.getExpectedHealth())) {
                            event.prevent();
                        }
                    });
                }
            }

            public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
                super.onBeforeHitCalculated(activeBuff, event);
                int level = this.getLevel(activeBuff);
                if (level >= params[0].valueInt() && this.runLogic(activeBuff, level, event.getExpectedHealth())) {
                    event.prevent();
                }
            }

            private boolean runLogic(ActiveBuff activeBuff, int skillLevel, int expectedHealth) {
                PlayerMob player;
                PlayerData playerData;
                Level level = activeBuff.owner.getLevel();
                if (level.isServer() && expectedHealth <= 0 && activeBuff.owner.isPlayer && (playerData = PlayerDataList.getPlayerData(player = (PlayerMob)activeBuff.owner)).getInUseActiveSkill() instanceof SimpleTranformationActiveSkill) {
                    int maxNumber = params[2].valueInt(skillLevel);
                    int inCooldownNumber = 0;
                    for (EquippedActiveSkill equippedActiveSkill : playerData.equippedActiveSkills) {
                        if (!(equippedActiveSkill.getActiveSkill() instanceof SimpleTranformationActiveSkill) || equippedActiveSkill.getCooldownLeft(player.getTime()) <= 60000) continue;
                        ++inCooldownNumber;
                    }
                    if (inCooldownNumber < maxNumber) {
                        player.dismount();
                        player.setHealth((int)((float)player.getMaxHealth() * params[1].value(skillLevel)));
                        playerData.getInUseActiveSkillSlot().startCustomCooldown(playerData, player.getTime(), 3600000);
                        player.getServer().network.sendToAllClients((Packet)new UpdateClientEquippedActiveSkillsPacket(playerData));
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

