/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import aphorea.registry.AphBuffs;
import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.LevelEventRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LineHitbox;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobDashLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.RPGResources;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.mobs.mount.TransformationMountMob;
import rpgclasses.mobs.summons.passive.RangerWolfMob;
import rpgclasses.utils.RPGArea;

public class WolfTransformation
extends SimpleTranformationActiveSkill {
    public static Buff wolfBarkBuff;
    public static SkillParam[] params;

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public WolfTransformation(int levelMax, int requiredClassLevel) {
        super("wolftransformation", "#E6D9CC", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 6000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return WolfMob.class;
    }

    @Override
    public void registry() {
        super.registry();
        LevelEventRegistry.registerEvent((String)(this.stringID + "chargelevelevent"), WolfChargeLevelEvent.class);
        wolfBarkBuff = BuffRegistry.registerBuff((String)"wolfbark", (Buff)new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                activeBuff.setModifier(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.0f + activeBuff.getGndData().getFloat("incomingDamage")));
            }
        });
    }

    static {
        params = new SkillParam[]{SkillParam.staticParam(3.0f), SkillParam.staticParam(60.0f), SkillParam.damageParam(3.0f), SkillParam.staticParam(3.0f), SkillParam.staticParam(2.0f), new SkillParam("10 x <skilllevel>").setDecimals(2, 0)};
    }

    public static class WolfMob
    extends SkillTransformationMountMob {
        public WolfMob() {
            this.setSpeed(params[1].value());
            this.setFriction(4.0f);
            this.setKnockbackModifier(0.5f);
            this.moveAccuracy = 8;
            this.collision = new Rectangle(-10, -7, 20, 14);
            this.hitBox = new Rectangle(-14, -12, 28, 24);
            this.selectBox = new Rectangle(-18, -24, 36, 36);
            this.swimMaskMove = 16;
            this.swimMaskOffset = 0;
            this.swimSinkOffset = -12;
        }

        public void spawnDeathParticles(float knockbackX, float knockbackY) {
            for (int i = 0; i < 4; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), RangerWolfMob.texture, 12, i, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }

        protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(x / 32, y / 32);
            int drawX = camera.getDrawX(x) - 32;
            int drawY = camera.getDrawY(y) - 36;
            int dir = this.getDir();
            Point sprite = this.getAnimSprite(x, y, dir);
            drawY += this.getBobbing(x, y);
            final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
            TextureDrawOptionsEnd body = RangerWolfMob.texture.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
            list.add(new MobDrawable((DrawOptions)body){
                final /* synthetic */ DrawOptions val$body;
                {
                    this.val$body = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    swimMask.use();
                    this.val$body.draw();
                    swimMask.stop();
                }
            });
            TextureDrawOptionsEnd shadow = MobRegistry.Textures.snowWolf.shadow.initDraw().sprite(0, sprite.y, 64).light(light).pos(drawX, drawY);
            tileList.add(arg_0 -> WolfMob.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
        }

        public int getRockSpeed() {
            return 7;
        }

        @Override
        public int clickCooldown() {
            return 1000;
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            float dx = x - player.getX();
            float dy = y - player.getY();
            float length = (float)Math.sqrt(dx * dx + dy * dy);
            float dirX = dx / length;
            float dirY = dy / length;
            int skillLevel = this.getActualSkillLevel();
            WolfChargeLevelEvent event = new WolfChargeLevelEvent(this, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), dirX, dirY, 80.0f, 200, new GameDamage(DamageTypeRegistry.MELEE, params[2].value(playerData.getLevel(), skillLevel)));
            player.getLevel().entityManager.events.addHidden((LevelEvent)event);
            player.getServer().network.sendToClientsWithEntity((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event);
        }

        @Override
        public boolean staminaBasedMountAbility() {
            return true;
        }

        @Override
        public boolean canRunMountAbility(PlayerMob player, Packet content) {
            return player.isServer() && !Settings.strictServerAuthority || StaminaBuff.canStartStaminaUsage((Mob)player);
        }

        @Override
        public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
            if (!this.inLiquid()) {
                this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
            }
        }

        @Override
        public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
            if (this.inLiquid()) {
                this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
            } else {
                long msToDeplete;
                float usage;
                ActiveBuff speedBuff = this.buffManager.getBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE);
                if (speedBuff != null) {
                    speedBuff.setDurationLeftSeconds(1.0f);
                } else {
                    this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
                }
                if (!(this.moveX == 0.0f && this.moveY == 0.0f || this.dx == 0.0f && this.dy == 0.0f || StaminaBuff.useStaminaAndGetValid((Mob)player, (float)(usage = 50.0f / (float)(msToDeplete = 5000L))))) {
                    return false;
                }
            }
            return !isRunningClient || Control.TRINKET_ABILITY.isDown();
        }

        @Override
        public void onActiveMountAbilityStopped(PlayerMob playerMob) {
            this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
        }

        @Override
        public boolean hasSecondaryClick() {
            return true;
        }

        @Override
        public int secondaryClickCooldown() {
            return 500;
        }

        @Override
        public void secondaryClickRun(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRun(level, x, y, player);
            AphAreaList areaList = new AphAreaList(new AphArea[]{new RPGArea(100.0f, new Color(255, 0, 0, 51)).addBuffGND(wolfBarkBuff.getStringID(), new GNDItemMap().setFloat("incomingDamage", params[5].value())).setDebuffArea((int)(params[4].value() * 1000.0f), new String[]{"provocationactiveskillbuff", wolfBarkBuff.getStringID()})}).setOnlyVision(false);
            areaList.execute((Mob)player, false);
        }

        @Override
        public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)RPGResources.SOUNDS.Bark, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.8f).pitch(GameRandom.globalRandom.getFloatOffset(0.9f, 0.1f)));
        }

        private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
            shadow.draw();
        }
    }

    public static class WolfChargeLevelEvent
    extends MobDashLevelEvent {
        public WolfChargeLevelEvent() {
        }

        public WolfChargeLevelEvent(Mob owner, int seed, float dirX, float dirY, float distance, int animTime, GameDamage damage) {
            super(owner, seed, dirX, dirY, distance, animTime, damage);
        }

        public PlayerMob getPlayer() {
            Mob rider = this.owner.getRider();
            return rider instanceof PlayerMob ? (PlayerMob)rider : null;
        }

        public void init() {
            super.init();
            if (this.level != null && this.level.isClient() && this.owner != null) {
                float forceMod = Math.min((float)this.animTime / 700.0f, 1.0f);
                float forceX = this.dirX * this.distance * forceMod;
                float forceY = this.dirY * this.distance * forceMod;
                for (int i = 0; i < 30; ++i) {
                    this.level.entityManager.addParticle(this.owner.x + (float)GameRandom.globalRandom.nextGaussian() * 15.0f + forceX / 5.0f, this.owner.y + (float)GameRandom.globalRandom.nextGaussian() * 20.0f + forceY / 5.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(forceX * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f, forceY * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(204, 255, 255)})).height(18.0f).lifeTime(700);
                }
                SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(0.5f).pitch(2.0f));
            }
            if (this.owner != null) {
                Mob rider = this.getRider();
                if (rider != null) {
                    rider.buffManager.addBuff(new ActiveBuff(BuffRegistry.INVULNERABLE_ACTIVE, this.owner, this.animTime, null), false);
                }
                this.owner.addBuff(new ActiveBuff(AphBuffs.SABER_DASH_ACTIVE, this.owner, this.animTime, null), false);
            }
        }

        public boolean canHit(Mob mob) {
            PlayerMob player = this.getPlayer();
            return player != null && mob.canBeTargeted((Mob)player, player.getNetworkClient()) && this.hitCooldowns.canHit(mob);
        }

        public void serverHit(Mob target, Packet content, boolean clientSubmitted) {
            if (clientSubmitted || this.hitCooldowns.canHit(target)) {
                PlayerMob player;
                if (this.damage != null && (player = this.getPlayer()) != null) {
                    target.isServerHit(this.damage, this.dirX, this.dirY, 75.0f, (Attacker)player);
                }
                TransformationMountMob.doResilienceGain(this.getRider(), target, params[3].value());
                this.hitCooldowns.startCooldown(target);
            }
        }

        public Shape getHitBox() {
            Point2D.Float dir = this.owner.getDir() == 3 ? GameMath.getPerpendicularDir((float)(-this.dirX), (float)(-this.dirY)) : GameMath.getPerpendicularDir((float)this.dirX, (float)this.dirY);
            float width = 20.0f;
            float frontOffset = 20.0f;
            float range = 40.0f;
            float rangeOffset = -20.0f;
            return new LineHitbox(this.owner.x + dir.x * rangeOffset + this.dirX * frontOffset, this.owner.y + dir.y * rangeOffset + this.dirY * frontOffset, dir.x, dir.y, range, width);
        }

        public Mob getRider() {
            return this.owner.getRider();
        }
    }
}

