/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.SeedBulletProjectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.objectItem.SeedObjectItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.SeedGunProjectileToolItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.mobs.summons.damageable.DryadSaplingDamageableSummonMob;
import rpgclasses.registry.RPGBuffs;

public class TreantTransformation
extends SimpleTranformationActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(4.0f), SkillParam.staticParam(0.0f), new SkillParam("50 + 5 x <skilllevel>").setDecimals(2, 0), SkillParam.staticParam(50.0f).setDecimals(2, 0), SkillParam.staticParam(5.0f), SkillParam.damageParam(0.5f), SkillParam.staticParam(1.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public TreantTransformation(int levelMax, int requiredClassLevel) {
        super("treanttransformation", "#753b09", levelMax, requiredClassLevel);
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"dryadsapling"};
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 10000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return TreantMob.class;
    }

    public static class TreantMob
    extends SkillTransformationMountMob {
        public TreantMob() {
            this.setSpeed(params[1].value());
            this.setFriction(2.0f);
            this.setSwimSpeed(0.75f);
            this.setFriction(3.0f);
            this.setKnockbackModifier(0.0f);
            this.collision = new Rectangle(-27, -27, 54, 54);
            this.hitBox = new Rectangle(-32, -27, 64, 54);
            this.selectBox = new Rectangle(-43, -80, 86, 112);
            this.swimMaskMove = 28;
            this.swimMaskOffset = -75;
            this.swimSinkOffset = -4;
        }

        @Override
        public List<ModifierValue<?>> getRiderModifiers() {
            List<ModifierValue<?>> modifiers = super.getRiderModifiers();
            int skillLevel = this.getActualSkillLevel();
            modifiers.add(new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.0f - params[2].value(skillLevel))));
            modifiers.add(new ModifierValue(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(-1.0f)));
            modifiers.add(new ModifierValue(BuffModifiers.ARMOR, (Object)Float.valueOf(params[3].value())));
            return modifiers;
        }

        public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(x / 32, y / 32);
            int drawX = camera.getDrawX(x) - 64;
            int drawY = camera.getDrawY(y) - 112 + 20;
            drawY += this.getBobbing(x, y);
            Point sprite = this.getSpeed() == 0.0f ? new Point(0, 4) : this.getAnimSprite(x, y, this.getDir());
            final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
            int spriteRes = 128;
            TextureDrawOptionsEnd options = MobRegistry.Textures.dryadSentinel.initDraw().sprite(sprite.x, sprite.y, spriteRes).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
            list.add(new MobDrawable((DrawOptions)options){
                final /* synthetic */ DrawOptions val$options;
                {
                    this.val$options = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    swimMask.use();
                    this.val$options.draw();
                    swimMask.stop();
                }
            });
            TextureDrawOptionsEnd shadow = MobRegistry.Textures.dryadSentinel_shadow.initDraw().sprite(sprite.x, sprite.y, spriteRes, spriteRes).light(light).pos(drawX, drawY);
            tileList.add(arg_0 -> TreantMob.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
        }

        public int getRockSpeed() {
            return 17;
        }

        @Override
        public int clickCooldown() {
            return 200;
        }

        @Override
        public int secondaryClickCooldown() {
            return 1500;
        }

        public void spawnDeathParticles(float knockbackX, float knockbackY) {
            for (int i = 0; i < 8; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.dryadSentinel, i + 12, 20, 32, this.x, this.y, 50.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            float dx = (float)x - player.x;
            float dy = (float)y - player.y;
            float angle = (float)Math.atan2(dy, dx);
            float offset = (float)((Math.random() * 2.0 - 1.0) * Math.toRadians(15.0));
            float distance = (float)Math.sqrt(dx * dx + dy * dy);
            float newX = player.x + (float)Math.cos(angle += offset) * distance;
            float newY = player.y + (float)Math.sin(angle) * distance;
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            int skillLevel = this.getActualSkillLevel();
            SeedBulletProjectile projectile = new SeedBulletProjectile(player.x, player.y, newX, newY, 150.0f, 400, new GameDamage(DamageTypeRegistry.RANGED, params[5].value(playerData.getLevel(), skillLevel)), 10, (Mob)player);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(params[6].value()));
            projectile.resetUniqueID(new GameRandom((long)Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom)));
            Item item = ItemRegistry.getItem((String)((String)GameRandom.globalRandom.getOneOf(new ArrayList(SeedGunProjectileToolItem.SEED_AMMO_TYPES))));
            if (item instanceof SeedObjectItem) {
                projectile.setSeedBulletVariant((SeedObjectItem)item);
            }
            this.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
            this.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }

        @Override
        public void clickRunClient(Level level, int x, int y, PlayerMob player) {
            super.clickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.5f).pitch(3.0f));
        }

        @Override
        public void secondaryClickRunServer(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunServer(level, x, y, player);
            DryadSaplingDamageableSummonMob mob = (DryadSaplingDamageableSummonMob)MobRegistry.getMob((String)"dryadsaplingdamageablesummon", (Level)player.getLevel());
            player.serverFollowersManager.addFollower(this.getStringID() + "follower", (Mob)mob, FollowPosition.WALK_CLOSE, null, 1.0f, 100, null, true);
            mob.updateStats(player, PlayerDataList.getPlayerData(player));
            mob.getLevel().entityManager.addMob((Mob)mob, player.x, player.y);
        }

        @Override
        public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.dryadSentinelGrowl, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.8f));
        }

        @Override
        public boolean hasSecondaryClick() {
            return true;
        }

        @Override
        public boolean staminaBasedMountAbility() {
            return true;
        }

        @Override
        public boolean canRunClick(PlayerMob player) {
            return this.getSpeed() > 0.0f && super.canRunClick(player);
        }

        @Override
        public boolean canRunSecondaryClick(PlayerMob player) {
            return this.getSpeed() > 0.0f && super.canRunSecondaryClick(player);
        }

        @Override
        public boolean canRunMountAbility(PlayerMob player, Packet content) {
            return player.isServer() && !Settings.strictServerAuthority || StaminaBuff.canStartStaminaUsage((Mob)player);
        }

        @Override
        protected void doMountedLogic() {
            super.doMountedLogic();
            if (this.getRider() != null) {
                this.getRider().addBuff(new ActiveBuff(RPGBuffs.TARGET_RANGE_TO_100, this.getRider(), params[4].value(), null), this.isServer());
            }
        }

        @Override
        public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
            this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
            player.buffManager.addBuff(new ActiveBuff(RPGBuffs.TARGET_RANGE_TO_100, (Mob)player, params[4].value(), null), false);
        }

        @Override
        public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
            long msToDeplete;
            float usage;
            ActiveBuff speedBuff = this.buffManager.getBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE);
            if (speedBuff != null) {
                speedBuff.setDurationLeftSeconds(1.0f);
            } else {
                this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
            }
            ActiveBuff targetRangeBuff = player.buffManager.getBuff(RPGBuffs.TARGET_RANGE_TO_100);
            if (targetRangeBuff != null) {
                targetRangeBuff.setDurationLeftSeconds(3.0f);
            } else {
                player.buffManager.addBuff(new ActiveBuff(RPGBuffs.TARGET_RANGE_TO_100, (Mob)player, 3.0f, null), false);
            }
            if (!(this.moveX == 0.0f && this.moveY == 0.0f || this.dx == 0.0f && this.dy == 0.0f || StaminaBuff.useStaminaAndGetValid((Mob)player, (float)(usage = 50.0f / (float)(msToDeplete = 10000L))))) {
                return false;
            }
            return !isRunningClient || Control.TRINKET_ABILITY.isDown();
        }

        @Override
        public void onActiveMountAbilityStopped(PlayerMob playerMob) {
            this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
        }

        @Override
        public boolean canBePushed(Mob other) {
            return false;
        }

        private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
            shadow.draw();
        }
    }
}

