/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import aphorea.registry.AphBuffs;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.LevelEventRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LineHitbox;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobDashLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.RPGResources;
import rpgclasses.buffs.MagicPoisonBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.registry.RPGModifiers;

public class RatTransformation
extends SimpleTranformationActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(2.0f), SkillParam.staticParam(25.0f), SkillParam.staticParam(50.0f).setDecimals(2, 0), SkillParam.staticParam(1000.0f).setDecimals(2, 0), SkillParam.damageParam(0.3f), SkillParam.staticParam(100.0f).setDecimals(2, 0), SkillParam.staticParam(10.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public RatTransformation(int levelMax, int requiredClassLevel) {
        super("rattransformation", "#6c6e6b", levelMax, requiredClassLevel);
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"dodgechance"};
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 2000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return RatMob.class;
    }

    @Override
    public void registry() {
        super.registry();
        LevelEventRegistry.registerEvent((String)(this.stringID + "chargelevelevent"), RatChargeLevelEvent.class);
    }

    public static class RatMob
    extends SkillTransformationMountMob {
        public RatMob() {
            this.setSpeed(params[1].value());
            this.setFriction(3.0f);
            this.collision = new Rectangle(-10, -7, 20, 14);
            this.hitBox = new Rectangle(-12, -14, 24, 24);
            this.selectBox = new Rectangle(-13, -18, 26, 28);
            this.swimMaskMove = 6;
            this.swimMaskOffset = 30;
            this.swimSinkOffset = 0;
        }

        @Override
        public List<ModifierValue<?>> getRiderModifiers() {
            List<ModifierValue<?>> modifiers = super.getRiderModifiers();
            float incomingDamage = params[3].value();
            modifiers.add(new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(incomingDamage)).min((Object)Float.valueOf(incomingDamage)));
            modifiers.add(new ModifierValue(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(-params[2].value())));
            modifiers.add(new ModifierValue(RPGModifiers.DODGE_CHANCE, (Object)Float.valueOf(0.8f)).min((Object)Float.valueOf(0.8f)));
            return modifiers;
        }

        public void spawnDeathParticles(float knockbackX, float knockbackY) {
            for (int i = 0; i < 4; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.mouse.body, 12, i, 16, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }

        public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(x / 32, y / 32);
            int drawX = camera.getDrawX(x) - 16;
            int drawY = camera.getDrawY(y) - 22;
            int dir = this.getDir();
            Point sprite = this.getAnimSprite(x, y, dir);
            drawY += this.getBobbing(x, y);
            boolean mirror = (dir == 0 || dir == 2) && this.moveX < 0.0f;
            final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
            TextureDrawOptionsEnd options = MobRegistry.Textures.mouse.body.initDraw().sprite(sprite.x, sprite.y, 32).addMaskShader(swimMask).mirror(mirror, false).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
            list.add(new MobDrawable((DrawOptions)options){
                final /* synthetic */ DrawOptions val$options;
                {
                    this.val$options = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    swimMask.use();
                    this.val$options.draw();
                    swimMask.stop();
                }
            });
            TextureDrawOptionsEnd shadow = MobRegistry.Textures.mouse.shadow.initDraw().sprite(0, dir, 32).mirror(mirror, false).light(light).pos(drawX, drawY);
            tileList.add(arg_0 -> RatMob.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
        }

        public int getRockSpeed() {
            return 7;
        }

        @Override
        public int clickCooldown() {
            return 2000;
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            float dx = x - player.getX();
            float dy = y - player.getY();
            float length = (float)Math.sqrt(dx * dx + dy * dy);
            float dirX = dx / length;
            float dirY = dy / length;
            int skillLevel = this.getActualSkillLevel();
            RatChargeLevelEvent event = new RatChargeLevelEvent(this, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), dirX, dirY, 20.0f, 100, new GameDamage(DamageTypeRegistry.MELEE, params[4].value(playerData.getLevel(), skillLevel)));
            player.getLevel().entityManager.events.add((LevelEvent)event);
            player.getServer().network.sendToClientsWithEntity((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event);
        }

        public void playDeathSound() {
            SoundManager.playSound((GameSound)RPGResources.SOUNDS.Rat, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.0f));
        }

        @Override
        public boolean staminaBasedMountAbility() {
            return true;
        }

        @Override
        public boolean canRunMountAbility(PlayerMob player, Packet content) {
            return player.isServer() && !Settings.strictServerAuthority || StaminaBuff.canStartStaminaUsage((Mob)player);
        }

        @Override
        public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
            if (!this.inLiquid()) {
                this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
            }
        }

        @Override
        public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
            if (this.inLiquid()) {
                this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
            } else {
                long msToDeplete;
                float usage;
                ActiveBuff speedBuff = this.buffManager.getBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE);
                if (speedBuff != null) {
                    speedBuff.setDurationLeftSeconds(1.0f);
                } else {
                    this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
                }
                if (!(this.moveX == 0.0f && this.moveY == 0.0f || this.dx == 0.0f && this.dy == 0.0f || StaminaBuff.useStaminaAndGetValid((Mob)player, (float)(usage = 50.0f / (float)(msToDeplete = 3000L))))) {
                    return false;
                }
            }
            return !isRunningClient || Control.TRINKET_ABILITY.isDown();
        }

        @Override
        public void onActiveMountAbilityStopped(PlayerMob playerMob) {
            this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
        }

        private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
            shadow.draw();
        }
    }

    public static class RatChargeLevelEvent
    extends MobDashLevelEvent {
        public RatChargeLevelEvent() {
        }

        public RatChargeLevelEvent(Mob owner, int seed, float dirX, float dirY, float distance, int animTime, GameDamage damage) {
            super(owner, seed, dirX, dirY, distance, animTime, damage);
        }

        public PlayerMob getPlayer() {
            Mob rider = this.owner.getRider();
            return rider instanceof PlayerMob ? (PlayerMob)rider : null;
        }

        public void init() {
            super.init();
            if (this.level != null && this.level.isClient() && this.owner != null) {
                float forceMod = Math.min((float)this.animTime / 700.0f, 1.0f);
                float forceX = this.dirX * this.distance * forceMod;
                float forceY = this.dirY * this.distance * forceMod;
                for (int i = 0; i < 4; ++i) {
                    this.level.entityManager.addParticle(this.owner.x + (float)GameRandom.globalRandom.nextGaussian() * 4.0f + forceX / 5.0f, this.owner.y + (float)GameRandom.globalRandom.nextGaussian() * 4.0f + forceY / 5.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(forceX * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f, forceY * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 5.0f).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(204, 255, 255)})).height(18.0f).lifeTime(700);
                }
                SoundManager.playSound((GameSound)RPGResources.SOUNDS.Rat, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(0.6f).pitch(GameRandom.globalRandom.getFloatOffset(0.95f, 0.05f)));
            }
            if (this.owner != null) {
                Mob rider = this.getRider();
                if (rider != null) {
                    rider.buffManager.addBuff(new ActiveBuff(BuffRegistry.INVULNERABLE_ACTIVE, this.owner, this.animTime, null), false);
                }
                this.owner.addBuff(new ActiveBuff(AphBuffs.SABER_DASH_ACTIVE, this.owner, this.animTime, null), false);
            }
        }

        public boolean canHit(Mob mob) {
            PlayerMob player = this.getPlayer();
            return player != null && mob.canBeTargeted((Mob)player, player.getNetworkClient()) && this.hitCooldowns.canHit(mob);
        }

        public void serverHit(Mob target, Packet content, boolean clientSubmitted) {
            if (clientSubmitted || this.hitCooldowns.canHit(target)) {
                PlayerMob player;
                if (this.damage != null && (player = this.getPlayer()) != null) {
                    target.isServerHit(this.damage, this.dirX, this.dirY, 10.0f, (Attacker)player);
                    MagicPoisonBuff.apply((Mob)player, target, params[5].value() * this.damage.damage, params[6].value());
                }
                this.hitCooldowns.startCooldown(target);
            }
        }

        public Shape getHitBox() {
            Point2D.Float dir = this.owner.getDir() == 3 ? GameMath.getPerpendicularDir((float)(-this.dirX), (float)(-this.dirY)) : GameMath.getPerpendicularDir((float)this.dirX, (float)this.dirY);
            float width = 10.0f;
            float frontOffset = 10.0f;
            float range = 20.0f;
            float rangeOffset = -10.0f;
            return new LineHitbox(this.owner.x + dir.x * rangeOffset + this.dirX * frontOffset, this.owner.y + dir.y * rangeOffset + this.dirY * frontOffset, dir.x, dir.y, range, width);
        }

        public Mob getRider() {
            return this.owner.getRider();
        }
    }
}

