/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import aphorea.projectiles.toolitem.HoneyProjectile;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.ShownCooldownBuff;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.mobs.summons.damageable.BeeDamageableSummonMob;
import rpgclasses.registry.RPGBuffs;

public class QueenBeeTransformation
extends SimpleTranformationActiveSkill {
    public static Buff queenBeeWasHitBuff;
    public static SkillParam[] params;

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public QueenBeeTransformation(int levelMax, int requiredClassLevel) {
        super("queenbeetransformation", "#a98307", levelMax, requiredClassLevel);
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"bee"};
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 4000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return QueenBeeMob.class;
    }

    @Override
    public void registry() {
        super.registry();
        queenBeeWasHitBuff = BuffRegistry.registerBuff((String)"queenbeewashit", (Buff)new ShownCooldownBuff());
    }

    static {
        params = new SkillParam[]{SkillParam.staticParam(2.0f), SkillParam.staticParam(30.0f), SkillParam.staticParam(50.0f).setDecimals(2, 0), SkillParam.staticParam(1000.0f).setDecimals(2, 0), new SkillParam("20 - 2 x <skilllevel>"), SkillParam.damageParam(3.0f), SkillParam.staticParam(2.0f), new SkillParam("3 + <skilllevel>").setDecimals(0)};
    }

    public static class QueenBeeMob
    extends SkillTransformationMountMob {
        public QueenBeeMob() {
            this.setSpeed(params[1].value());
            this.setFriction(2.0f);
            this.setSwimSpeed(1.0f);
            this.collision = new Rectangle(-7, -5, 14, 10);
            this.hitBox = new Rectangle(-12, -14, 24, 24);
            this.selectBox = new Rectangle(-16, -28, 32, 34);
        }

        public int getFlyingHeight() {
            return 20;
        }

        @Override
        public boolean canPushMob(Mob other) {
            return false;
        }

        @Override
        public boolean canBePushed(Mob other) {
            return false;
        }

        @Override
        public List<ModifierValue<?>> getRiderModifiers() {
            List<ModifierValue<?>> modifiers = super.getRiderModifiers();
            float incomingDamage = params[3].value();
            modifiers.add(new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(incomingDamage)).min((Object)Float.valueOf(incomingDamage)));
            modifiers.add(new ModifierValue(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(-params[2].value())));
            return modifiers;
        }

        protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(x / 32, y / 32);
            int drawX = camera.getDrawX(x) - 16;
            int drawY = camera.getDrawY(y) - 22;
            int dir = this.getDir();
            int animationTime = 1000;
            long time = level.getTime();
            Point sprite = this.getAnimSprite(x, y, dir);
            TextureDrawOptionsEnd shadow = MobRegistry.Textures.queenBee.shadow.initDraw().sprite(0, dir, 32).light(light).pos(drawX, drawY);
            tileList.add(arg_0 -> QueenBeeMob.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
            float bobbingFloat = GameUtils.getBobbing((long)(time += (long)new GameRandom((long)this.getUniqueID()).nextInt(animationTime)), (int)animationTime);
            drawY -= 10;
            drawY = (int)((float)drawY + bobbingFloat * 5.0f);
            TextureDrawOptionsEnd options = MobRegistry.Textures.queenBee.body.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY);
            list.add(new MobDrawable((DrawOptions)options){
                final /* synthetic */ DrawOptions val$options;
                {
                    this.val$options = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }

        public Point getAnimSprite(int x, int y, int dir) {
            long time = this.getTime();
            return new Point(GameUtils.getAnim((long)(time += (long)new GameRandom((long)this.getUniqueID()).nextInt(200)), (int)2, (int)200), dir);
        }

        @Override
        public int clickCooldown() {
            return 300;
        }

        @Override
        public int secondaryClickCooldown() {
            return 1000;
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            int skillLevel = this.getActualSkillLevel();
            HoneyProjectile projectile = new HoneyProjectile(level, (Mob)player, player.x, player.y, (float)x, (float)y, 100.0f, 200, new GameDamage(DamageTypeRegistry.RANGED, params[5].value(playerData.getLevel(), skillLevel)), 20);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(params[6].value()));
            projectile.resetUniqueID(new GameRandom((long)Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom)));
            this.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
            this.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }

        @Override
        public void clickRunClient(Level level, int x, int y, PlayerMob player) {
            super.clickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.spit, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 1.2f)));
        }

        @Override
        public void secondaryClickRunServer(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunServer(level, x, y, player);
            this.summonBee(player);
        }

        @Override
        public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.5f).pitch(GameRandom.globalRandom.getFloatBetween(1.4f, 1.5f)));
        }

        @Override
        public boolean hasSecondaryClick() {
            return true;
        }

        @Override
        public boolean staminaBasedMountAbility() {
            return true;
        }

        @Override
        public boolean canRunMountAbility(PlayerMob player, Packet content) {
            return player.isServer() && !Settings.strictServerAuthority || StaminaBuff.canStartStaminaUsage((Mob)player);
        }

        @Override
        public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
            player.buffManager.addBuff(new ActiveBuff(RPGBuffs.AGGRESSIVE_BEES, (Mob)player, 1.0f, null), false);
        }

        @Override
        public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
            ActiveBuff buff = player.buffManager.getBuff(RPGBuffs.AGGRESSIVE_BEES);
            if (buff != null) {
                buff.setDurationLeftSeconds(1.0f);
            } else {
                player.buffManager.addBuff(new ActiveBuff(RPGBuffs.AGGRESSIVE_BEES, (Mob)player, 1.0f, null), false);
            }
            long msToDeplete = 20000L;
            float usage = 50.0f / (float)msToDeplete;
            if (!StaminaBuff.useStaminaAndGetValid((Mob)player, (float)usage)) {
                return false;
            }
            return !isRunningClient || Control.TRINKET_ABILITY.isDown();
        }

        @Override
        public void onActiveMountAbilityStopped(PlayerMob player) {
            player.buffManager.removeBuff(RPGBuffs.AGGRESSIVE_BEES, false);
        }

        @Override
        public void onBeforeHit(PlayerMob player, MobBeforeHitEvent event) {
            super.onBeforeHit(player, event);
            if (!player.buffManager.hasBuff(queenBeeWasHitBuff)) {
                event.prevent();
                event.showDamageTip = false;
                event.playHitSound = false;
                if (player.isServer()) {
                    int skillLevel = this.getActualSkillLevel();
                    player.buffManager.addBuff(new ActiveBuff(queenBeeWasHitBuff, (Mob)player, params[4].value(skillLevel), null), true);
                    int amount = (int)((float)params[7].valueInt(skillLevel) - player.serverFollowersManager.getFollowerCount(this.getStringID() + "follower"));
                    for (int i = 0; i < amount; ++i) {
                        this.summonBee(player);
                    }
                }
            }
        }

        public void summonBee(PlayerMob player) {
            BeeDamageableSummonMob mob = (BeeDamageableSummonMob)MobRegistry.getMob((String)"beedamageablesummon", (Level)player.getLevel());
            int skillLevel = this.getActualSkillLevel();
            player.serverFollowersManager.addFollower(this.getStringID() + "follower", (Mob)mob, FollowPosition.WALK_CLOSE, null, 1.0f, params[7].valueInt(skillLevel), null, true);
            mob.updateStats(player, PlayerDataList.getPlayerData(player));
            mob.getLevel().entityManager.addMob((Mob)mob, player.x + GameRandom.globalRandom.getFloatOffset(0.0f, 32.0f), player.y + GameRandom.globalRandom.getFloatOffset(0.0f, 32.0f));
        }

        private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
            shadow.draw();
        }
    }
}

