/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.mobs.mount.SkillTransformationMountSimpleAbilityMob;
import rpgclasses.mobs.summons.DancingFlameMob;
import rpgclasses.projectiles.MiniFireballProjectile;

public class FoxTransformation
extends SimpleTranformationActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(3.0f), SkillParam.staticParam(50.0f), SkillParam.staticParam(50.0f).setDecimals(2, 0), SkillParam.damageParam(4.0f), SkillParam.staticParam(2.0f), new SkillParam("2 + <skilllevel>").setDecimals(0)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public FoxTransformation(int levelMax, int requiredClassLevel) {
        super("foxtransformation", "#ff3300", levelMax, requiredClassLevel);
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"dancingflame"};
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 4000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return FoxMob.class;
    }

    @Override
    public boolean initMobTexture() {
        return true;
    }

    public static class FoxMob
    extends SkillTransformationMountSimpleAbilityMob {
        public FoxMob() {
            this.setSpeed(params[1].value());
            this.collision = new Rectangle(-10, -7, 20, 14);
            this.hitBox = new Rectangle(-14, -12, 28, 24);
            this.selectBox = new Rectangle(-18, -24, 36, 36);
        }

        @Override
        public List<ModifierValue<?>> getRiderModifiers() {
            List<ModifierValue<?>> modifiers = super.getRiderModifiers();
            modifiers.add(new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.0f + params[2].value())));
            return modifiers;
        }

        public void spawnDeathParticles(float knockbackX, float knockbackY) {
            GameTexture texture = this.getTexture();
            for (int i = 0; i < 3; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }

        protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(this.getTileX(), this.getTileY());
            int drawX = camera.getDrawX(x) - 32;
            int drawY = camera.getDrawY(y) - 43;
            int dir = this.getDir();
            Point sprite = this.getAnimSprite(x, y, dir);
            drawY += this.getBobbing(x, y);
            TextureDrawOptionsEnd drawOptions = this.getTexture().initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY += this.getLevel().getTile(this.getTileX(), this.getTileY()).getMobSinkingAmount((Mob)this));
            list.add(new MobDrawable((DrawOptions)drawOptions){
                final /* synthetic */ DrawOptions val$drawOptions;
                {
                    this.val$drawOptions = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    this.val$drawOptions.draw();
                }
            });
            this.addShadowDrawables(tileList, level, x, y, light, camera);
        }

        public int getRockSpeed() {
            return 15;
        }

        @Override
        public void runMountAbility(PlayerMob player) {
            this.buffManager.addBuff(new ActiveBuff(BuffRegistry.FOW_ACTIVE, (Mob)this, 0.15f, null), false);
            this.buffManager.forceUpdateBuffs();
            Point2D.Float dir = Skill.getDir(this);
            int strength = 150;
            float forceX = dir.x * (float)strength;
            float forceY = dir.y * (float)strength;
            if (Math.abs(this.dx) < Math.abs(forceX)) {
                this.dx = forceX;
            }
            if (Math.abs(this.dy) < Math.abs(forceY)) {
                this.dy = forceY;
            }
            if (this.isClient()) {
                for (int i = 0; i < 15; ++i) {
                    this.getLevel().entityManager.addParticle(this.x + (float)GameRandom.globalRandom.nextGaussian() * 12.0f + forceX / 10.0f, this.y + (float)GameRandom.globalRandom.nextGaussian() * 12.0f + forceY / 10.0f, Particle.GType.IMPORTANT_COSMETIC).movesConstant(forceX * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f, forceY * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f) / 10.0f).color(new Color(255, 204, 204)).height(18.0f).lifeTime(700);
                }
                SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.35f).pitch(1.7f));
            }
        }

        public GameDamage getDamage(PlayerMob player) {
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            int skillLevel = this.getActualSkillLevel();
            return new GameDamage(DamageTypeRegistry.MAGIC, params[3].value(playerData.getLevel(), skillLevel));
        }

        @Override
        public int mountAbilityCooldown() {
            return 2000;
        }

        @Override
        public int clickCooldown() {
            return 500;
        }

        @Override
        public int secondaryClickCooldown() {
            return 3000;
        }

        @Override
        public void clickRunServer(Level level, int x, int y, PlayerMob player) {
            super.clickRunServer(level, x, y, player);
            MiniFireballProjectile projectile = new MiniFireballProjectile(level, (Mob)player, player.x, player.y, x, y, 200.0f, 600, this.getDamage(player), 20);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(params[4].value()));
            projectile.resetUniqueID(new GameRandom((long)Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom)));
            this.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
            this.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }

        @Override
        public void clickRunClient(Level level, int x, int y, PlayerMob player) {
            super.clickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.spit, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.6f).pitch(GameRandom.globalRandom.getFloatBetween(1.4f, 1.5f)));
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.3f).pitch(GameRandom.globalRandom.getFloatBetween(1.4f, 1.5f)));
        }

        @Override
        public void secondaryClickRunServer(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunServer(level, x, y, player);
            DancingFlameMob mob = (DancingFlameMob)MobRegistry.getMob((String)"dancingflame", (Level)player.getLevel());
            int skillLevel = this.getActualSkillLevel();
            player.serverFollowersManager.addFollower(this.getStringID() + "follower", (Mob)mob, FollowPosition.FLYING_CIRCLE_FAST, null, 1.0f, params[5].valueInt(skillLevel), null, true);
            mob.updateDamage(this.getDamage(player));
            mob.getLevel().entityManager.addMob((Mob)mob, player.x, player.y);
        }

        @Override
        public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.5f).pitch(GameRandom.globalRandom.getFloatBetween(1.4f, 1.5f)));
        }

        @Override
        public boolean hasSecondaryClick() {
            return true;
        }
    }
}

