/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Druid.ActiveSkills;

import aphorea.registry.AphBuffs;
import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.SkillTransformationMountMob;
import rpgclasses.utils.RPGArea;
import rpgclasses.utils.RPGColors;

public class BearTransformation
extends SimpleTranformationActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(4.0f), SkillParam.staticParam(25.0f), SkillParam.staticParam(50.0f).setDecimals(2, 0), SkillParam.damageParam(4.0f), new SkillParam("0.5 x <skilllevel>"), SkillParam.staticParam(4.0f), SkillParam.staticParam(2.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public BearTransformation(int levelMax, int requiredClassLevel) {
        super("beartransformation", "#6c3b2a", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 8000;
    }

    @Override
    public int castingDuration() {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public Class<? extends SkillTransformationMountMob> getMobClass() {
        return WolfMob.class;
    }

    public static class WolfMob
    extends SkillTransformationMountMob {
        public WolfMob() {
            this.setSpeed(params[1].value());
            this.setKnockbackModifier(0.2f);
            this.moveAccuracy = 8;
            this.collision = new Rectangle(-10, -7, 20, 14);
            this.hitBox = new Rectangle(-20, -16, 40, 32);
            this.selectBox = new Rectangle(-20, -50, 40, 55);
            this.swimMaskMove = 32;
            this.swimMaskOffset = -55;
            this.swimSinkOffset = -8;
            this.prioritizeVerticalDir = false;
        }

        @Override
        public List<ModifierValue<?>> getRiderModifiers() {
            List<ModifierValue<?>> modifiers = super.getRiderModifiers();
            modifiers.add(new ModifierValue(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.0f - params[2].value())));
            return modifiers;
        }

        public void spawnDeathParticles(float knockbackX, float knockbackY) {
            for (int i = 0; i < 4; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.grizzlyBear, i, 16, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }

        protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
            GameLight light = level.getLightLevel(x / 32, y / 32);
            int drawX = camera.getDrawX(x) - 64;
            int drawY = camera.getDrawY(y) - 128 + 36;
            int dir = this.getDir();
            Point sprite = this.getAnimSprite(x, y, dir);
            drawY += this.getBobbing(x, y);
            final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
            TextureDrawOptionsEnd options = MobRegistry.Textures.grizzlyBear.initDraw().sprite(sprite.x, sprite.y, 128).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
            list.add(new MobDrawable((DrawOptions)options){
                final /* synthetic */ DrawOptions val$options;
                {
                    this.val$options = drawOptions;
                }

                public void draw(TickManager tickManager) {
                    swimMask.use();
                    this.val$options.draw();
                    swimMask.stop();
                }
            });
            this.addShadowDrawables(tileList, level, x, y, light, camera);
        }

        protected TextureDrawOptions getShadowDrawOptions(Level level, int x, int y, GameLight light, GameCamera camera) {
            GameTexture shadowTexture = MobRegistry.Textures.grizzlyBear_shadow;
            int drawX = camera.getDrawX(x) - 64;
            int drawY = camera.getDrawY(y) - 128 + 36;
            return shadowTexture.initDraw().sprite(0, this.getDir(), 128).light(light).pos(drawX, drawY += this.getBobbing(x, y));
        }

        public int getRockSpeed() {
            return 10;
        }

        @Override
        public int clickCooldown() {
            return 2000;
        }

        @Override
        public void clickRun(Level level, int x, int y, PlayerMob player) {
            Color debrisColor;
            super.clickRun(level, x, y, player);
            ActiveBuff ab = new ActiveBuff(AphBuffs.STOP, (Mob)player, 300, null);
            player.buffManager.addBuff(ab, false);
            Color colorArea = RPGColors.dirt;
            if (player.isClient() && (debrisColor = player.getLevel().getTile(player.getTileX(), player.getTileY()).getDebrisColor(player.getLevel(), player.getTileX(), player.getTileY())) != null) {
                colorArea = debrisColor;
            }
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            int skillLevel = this.getActualSkillLevel();
            AphAreaList areaList = new AphAreaList(new AphArea[]{new RPGArea(120.0f, colorArea).addOnTargetDamaged(target -> this.doResilienceGain((Mob)target, params[5].value())).setDebuffArea((int)(params[4].value(skillLevel) * 1000.0f), new String[]{AphBuffs.STUN.getStringID()}).setDamageArea(new GameDamage(DamageTypeRegistry.MELEE, params[3].value(playerData.getLevel(), skillLevel)))});
            areaList.execute((Mob)player, false);
        }

        @Override
        public void clickRunClient(Level level, int x, int y, PlayerMob player) {
            super.clickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.punch, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(0.5f));
            player.getClient().startCameraShake(player.x, player.y, 300, 40, 3.0f, 3.0f, true);
        }

        @Override
        public boolean hasSecondaryClick() {
            return true;
        }

        @Override
        public int secondaryClickCooldown() {
            return 10000;
        }

        @Override
        public void secondaryClickRun(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRun(level, x, y, player);
            AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(100.0f, new Color[]{new Color(51, 0, 255, 51)}).setDebuffArea((int)(params[6].value() * 1000.0f), new String[]{"intimidationactiveskillbuff"})}).setOnlyVision(false);
            areaList.execute((Mob)player, false);
        }

        @Override
        public void secondaryClickRunClient(Level level, int x, int y, PlayerMob player) {
            super.secondaryClickRunClient(level, x, y, player);
            SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.0f).pitch(0.5f));
        }

        @Override
        public boolean staminaBasedMountAbility() {
            return true;
        }

        @Override
        public boolean canRunMountAbility(PlayerMob player, Packet content) {
            return player.isServer() && !Settings.strictServerAuthority || StaminaBuff.canStartStaminaUsage((Mob)player);
        }

        @Override
        public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
            if (!this.inLiquid()) {
                this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
            }
        }

        @Override
        public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
            if (this.inLiquid()) {
                this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
            } else {
                long msToDeplete;
                float usage;
                ActiveBuff speedBuff = this.buffManager.getBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE);
                if (speedBuff != null) {
                    speedBuff.setDurationLeftSeconds(1.0f);
                } else {
                    this.buffManager.addBuff(new ActiveBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, (Mob)this, 1.0f, null), false);
                }
                if (!(this.moveX == 0.0f && this.moveY == 0.0f || this.dx == 0.0f && this.dy == 0.0f || StaminaBuff.useStaminaAndGetValid((Mob)player, (float)(usage = 50.0f / (float)(msToDeplete = 3000L))))) {
                    return false;
                }
            }
            return !isRunningClient || Control.TRINKET_ABILITY.isDown();
        }

        @Override
        public void onActiveMountAbilityStopped(PlayerMob playerMob) {
            this.buffManager.removeBuff(BuffRegistry.LEATHER_DASHERS_ACTIVE, false);
        }
    }
}

