/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.Passives;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import necesse.engine.network.Packet;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.gameFont.FontManager;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.EquippedActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.PacketMobResetBuffTime;
import rpgclasses.utils.RPGArea;
import rpgclasses.utils.RPGColors;

public class VitalAura
extends SimpleBuffPassive {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(10.0f), SkillParam.healingParam(1.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public VitalAura(int levelMax, int requiredClassLevel) {
        super("vitalaura", "#00ff00", levelMax, requiredClassLevel);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return new PrincipalPassiveBuff(){

            public void serverTick(ActiveBuff activeBuff) {
                super.serverTick(activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0);
                if ((time += 50) > (int)(params[0].value() * 1000.0f)) {
                    time = 0;
                    PlayerMob player = (PlayerMob)activeBuff.owner;
                    PlayerData playerData = PlayerDataList.getPlayerData(player);
                    AphAreaList areaList = new AphAreaList(new AphArea[]{new RPGArea(150.0f, RPGColors.green).setAttackerHealthMod(0.5f).setHealingArea(params[1].valueInt(playerData.getLevel(), this.getLevel(activeBuff)))}).setOnlyVision(false);
                    areaList.execute((Mob)player, true);
                    player.getServer().network.sendToClientsAtEntireLevel((Packet)new PacketMobResetBuffTime(player.getUniqueID(), VitalAura.this.getBuffStringID()), player.getLevel());
                }
                activeBuff.getGndData().setInt("time", time);
            }

            public void clientTick(ActiveBuff activeBuff) {
                super.clientTick(activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0);
                activeBuff.getGndData().setInt("time", time += 50);
            }

            public void drawIcon(int x, int y, ActiveBuff activeBuff) {
                super.drawIcon(x, y, activeBuff);
                int time = activeBuff.getGndData().getInt("time", 0) - 50;
                String text = EquippedActiveSkill.getTimeLeftString(params[0].valueInt(this.getLevel(activeBuff)) * 1000 - time);
                int width = FontManager.bit.getWidthCeil(text, durationFontOptions);
                FontManager.bit.drawString((float)(x + 28 - width), (float)(y + 30 - FontManager.bit.getHeightCeil(text, durationFontOptions)), text, durationFontOptions);
            }
        };
    }
}

