/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.MobData;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGDamageType;
import rpgclasses.utils.RPGArea;
import rpgclasses.utils.RPGUtils;

public class WrathOfLight
extends SimpleLevelEventActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(3.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(40.0f);
    }

    public WrathOfLight(int levelMax, int requiredClassLevel) {
        super("wrathoflight", "#ffff66", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        Mob target = RPGUtils.findBestTarget((Mob)player, 500);
        if (target != null) {
            RPGBuffs.applyStun(target, 500);
            return new WrathOfLightLevelEvent((Mob)player, target.getX(), target.getY(), params[0].value(playerData.getLevel(), activeSkillLevel) / 2.0f);
        }
        return null;
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return WrathOfLightLevelEvent.class;
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        return RPGUtils.anyTarget((Mob)player, 500) ? null : "notarget";
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"holydamage", "constrained"};
    }

    public static class WrathOfLightLevelEvent
    extends MobAbilityLevelEvent
    implements Attacker {
        private int lifeTime = 0;
        public int nextHit = 0;
        public int targetX;
        public int targetY;
        public float damage;
        public int hits;

        public WrathOfLightLevelEvent() {
        }

        public WrathOfLightLevelEvent(Mob owner, int targetX, int targetY, float damage) {
            super(owner, new GameRandom());
            this.targetX = targetX;
            this.targetY = targetY;
            this.damage = damage;
            this.hits = 0;
        }

        public void init() {
            super.init();
            if (this.isClient()) {
                SoundManager.playSound((GameSound)GameResources.glyphChargeUp, (SoundEffect)SoundEffect.effect((float)this.targetX, (float)this.targetY).volume(10.0f).pitch(0.5f));
                this.owner.getLevel().entityManager.addParticle((Particle)new WrathOfLightParticle(this.owner.getLevel(), this.targetX, this.targetY, 5000L), Particle.GType.CRITICAL);
            }
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextShortUnsigned(this.lifeTime);
            writer.putNextShortUnsigned(this.nextHit);
            writer.putNextInt(this.targetX);
            writer.putNextInt(this.targetY);
            writer.putNextFloat(this.damage);
            writer.putNextInt(this.hits);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.lifeTime = reader.getNextShortUnsigned();
            this.nextHit = reader.getNextShortUnsigned();
            this.targetX = reader.getNextInt();
            this.targetY = reader.getNextInt();
            this.damage = reader.getNextFloat();
            this.hits = reader.getNextInt();
        }

        public void clientTick() {
            super.clientTick();
            this.lifeTime += 50;
            if (this.hits < 10) {
                if (this.lifeTime >= this.hits * 500) {
                    this.clientHit();
                }
            } else {
                this.clientHit();
                this.over();
            }
        }

        public void serverTick() {
            super.serverTick();
            this.lifeTime += 50;
            if (this.hits < 10) {
                if (this.lifeTime >= this.hits * 500) {
                    this.serverHit();
                }
            } else {
                this.serverHit();
                this.over();
            }
        }

        public void serverHit() {
            ++this.hits;
            RPGUtils.getAllTargets(this.owner, 200).forEach(mob -> {
                mob.isServerHit(new GameDamage(RPGDamageType.HOLY, this.damage), (float)this.targetX, (float)this.targetY, -20.0f, (Attacker)this.owner);
                if (MobData.isWeakToHoly(mob, this.owner)) {
                    mob.buffManager.addBuff(new ActiveBuff(RPGBuffs.CONSTRAINED, mob, 1100, null), true);
                }
            });
        }

        public void clientHit() {
            ++this.hits;
            new AphAreaList(new AphArea[]{new RPGArea(200.0f, new Color(255, 255, 102))}).setOnlyVision(false).executeClient(this.owner.getLevel(), (float)this.targetX, (float)this.targetY);
        }

        public void clientHit(Mob target, Packet content) {
        }
    }

    public static class WrathOfLightParticle
    extends Particle {
        public WrathOfLightParticle(Level level, float x, float y, long lifeTime) {
            super(level, x, y, lifeTime);
        }

        public void clientTick() {
            super.clientTick();
            this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 0.13f, 1.0f);
        }

        public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (!this.removed()) {
                GameTexture texture = RPGResources.PARTICLE_TEXTURES.wrathOfLight;
                int drawX = camera.getDrawX(this.x) - texture.getWidth() / 2;
                int drawY = camera.getDrawY(this.y) - texture.getHeight();
                TextureDrawOptionsEnd options = texture.initDraw().pos(drawX, drawY);
                list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                    final /* synthetic */ TextureDrawOptions val$options;
                    {
                        this.val$options = textureDrawOptions;
                        super(arg0);
                    }

                    public void draw(TickManager tickManager) {
                        this.val$options.draw();
                    }
                });
            }
        }
    }
}

