/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import rpgclasses.RPGResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.MobData;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGDamageType;
import rpgclasses.utils.RPGUtils;

public class Smite
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.damageParam(5.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f);
    }

    public Smite(int levelMax, int requiredClassLevel) {
        super("smite", "#ffff66", levelMax, requiredClassLevel);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 8000;
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        Mob target = RPGUtils.findBestTarget((Mob)player, 300);
        if (target != null) {
            float damage = params[0].value(playerData.getLevel(), activeSkillLevel);
            if (MobData.isWeakToHoly(target, (Mob)player)) {
                damage *= 2.0f;
            }
            target.isServerHit(new GameDamage(RPGDamageType.HOLY, damage), player.x, player.y, 0.0f, (Attacker)player);
            RPGBuffs.applyStun(target, 300);
        }
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.glyphTrapCharge, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(0.5f));
        Mob target = RPGUtils.findBestTarget((Mob)player, 300);
        if (target != null) {
            target.getLevel().entityManager.addParticle((Particle)new SmiteParticle(target.getLevel(), target.x, target.y, 300L), Particle.GType.CRITICAL);
        }
    }

    @Override
    public String canActive(PlayerMob player, PlayerData playerData, int activeSkillLevel, boolean isInUSe) {
        return RPGUtils.anyTarget((Mob)player, 300) ? null : "notarget";
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"holydamage", "constrained"};
    }

    public static class SmiteParticle
    extends Particle {
        public SmiteParticle(Level level, float x, float y, long lifeTime) {
            super(level, x, y, lifeTime);
        }

        public void clientTick() {
            super.clientTick();
            this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 0.13f, 1.0f);
        }

        public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (!this.removed()) {
                GameTexture texture = RPGResources.PARTICLE_TEXTURES.smite;
                int drawX = camera.getDrawX(this.x) - texture.getWidth() / 2;
                int drawY = camera.getDrawY(this.y) - texture.getHeight();
                TextureDrawOptionsEnd options = texture.initDraw().pos(drawX, drawY);
                list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                    final /* synthetic */ TextureDrawOptions val$options;
                    {
                        this.val$options = textureDrawOptions;
                        super(arg0);
                    }

                    public void draw(TickManager tickManager) {
                        this.val$options.draw();
                    }
                });
            }
        }
    }
}

