/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import java.awt.Color;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleLevelEventActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.MobData;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGUtils;

public class Sanctuary
extends SimpleLevelEventActiveSkill {
    public static Buff sanctuaryBuff;
    public static SkillParam[] params;

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(30.0f, false);
    }

    public Sanctuary(int levelMax, int requiredClassLevel) {
        super("sanctuary", "#ffff22", levelMax, requiredClassLevel);
    }

    @Override
    public LevelEvent getLevelEvent(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        return new SanctuaryLevelEvent((Mob)player, player.getX(), player.getY(), 8.0f);
    }

    @Override
    public Class<? extends LevelEvent> getLevelEventClass() {
        return SanctuaryLevelEvent.class;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 40000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return -2000;
    }

    @Override
    public void registry() {
        super.registry();
        sanctuaryBuff = BuffRegistry.registerBuff((String)this.getBuffStringID(), (Buff)new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                activeBuff.setModifier(BuffModifiers.COMBAT_HEALTH_REGEN_FLAT, (Object)Float.valueOf(activeBuff.getGndData().getFloat("healthRegen")));
            }
        });
    }

    public void giveBuff(Mob target, int duration) {
        ActiveBuff ab = this.getActiveBuff(target, duration);
        target.buffManager.addBuff(ab, target.isServer());
    }

    public ActiveBuff getActiveBuff(Mob target, int duration) {
        return new ActiveBuff(this.getBuffStringID(), target, duration, null);
    }

    public String getBuffStringID() {
        return this.stringID + "activeskillbuff";
    }

    static {
        params = new SkillParam[]{SkillParam.healingParam(0.2f).setDecimals(2)};
    }

    public static class SanctuaryLevelEvent
    extends MobAbilityLevelEvent
    implements Attacker {
        private int lifeTime = 0;
        public int nextHit = 0;
        public int targetX;
        public int targetY;
        public float healthRegen;
        public static int maxRange = 400;

        public SanctuaryLevelEvent() {
        }

        public SanctuaryLevelEvent(Mob owner, int targetX, int targetY, float healthRegen) {
            super(owner, new GameRandom());
            this.targetX = targetX;
            this.targetY = targetY;
            this.healthRegen = healthRegen;
        }

        public void setupSpawnPacket(PacketWriter writer) {
            super.setupSpawnPacket(writer);
            writer.putNextShortUnsigned(this.lifeTime);
            writer.putNextShortUnsigned(this.nextHit);
            writer.putNextInt(this.targetX);
            writer.putNextInt(this.targetY);
            writer.putNextFloat(this.healthRegen);
        }

        public void applySpawnPacket(PacketReader reader) {
            super.applySpawnPacket(reader);
            this.lifeTime = reader.getNextShortUnsigned();
            this.nextHit = reader.getNextShortUnsigned();
            this.targetX = reader.getNextInt();
            this.targetY = reader.getNextInt();
            this.healthRegen = reader.getNextFloat();
        }

        public void clientTick() {
            super.clientTick();
            this.tick();
        }

        public void serverTick() {
            super.serverTick();
            this.tick();
        }

        public void tick() {
            this.lifeTime += 50;
            int range = 0;
            if (this.lifeTime < 1000) {
                range = (int)((float)maxRange * ((float)this.lifeTime / 1000.0f));
            } else if (this.lifeTime <= 7000) {
                range = maxRange;
            } else if (this.lifeTime <= 8000) {
                range = (int)((float)maxRange * (1.0f - (float)(this.lifeTime - 7000) / 1000.0f));
            } else {
                this.over();
            }
            if (range > 0) {
                if (this.isServer()) {
                    RPGUtils.streamMobsAndPlayers(this.owner, range).forEach(mob -> {
                        if (mob == this.owner || mob.isSameTeam(this.owner)) {
                            RPGBuffs.purify(mob, true);
                            ActiveBuff ab = new ActiveBuff(sanctuaryBuff.getStringID(), mob, 100, null);
                            ab.getGndData().setFloat("healthRegen", this.healthRegen);
                            mob.buffManager.addBuff(ab, true);
                        } else if (MobData.isWeakToHoly(mob, this.owner)) {
                            mob.buffManager.addBuff(new ActiveBuff(RPGBuffs.CONSTRAINED, mob, 100, null), true);
                        }
                    });
                } else if (this.isClient()) {
                    int particleCount = (int)((double)(range * range) * 0.002);
                    for (int i = 0; i < particleCount; ++i) {
                        float angle = GameRandom.globalRandom.getFloatBetween(0.0f, 360.0f);
                        float radius = (float)Math.sqrt(GameRandom.globalRandom.nextFloat()) * (float)range;
                        float px = (float)this.targetX + GameMath.cos((float)angle) * radius;
                        float py = (float)this.targetY + GameMath.sin((float)angle) * radius;
                        this.getLevel().entityManager.addParticle(px, py, Particle.GType.IMPORTANT_COSMETIC).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(255, 255, 0), new Color(255, 255, 153), new Color(255, 255, 204)})).heightMoves(0.0f, GameRandom.globalRandom.getFloatBetween(16.0f, 24.0f));
                    }
                }
            }
        }
    }
}

