/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.utils.RPGArea;
import rpgclasses.utils.RPGUtils;

public class Purify
extends ActiveSkill {
    public static SkillParam[] params = new SkillParam[0];

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f);
    }

    public Purify(int levelMax, int requiredClassLevel) {
        super("purify", "#ccffcc", levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        RPGUtils.streamMobsAndPlayers((Mob)player, 200).filter(m -> m == player || m.isSameTeam((Mob)player)).forEach(m -> RPGBuffs.purify(m, player.isServer()));
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(1.0f).pitch(2.0f));
        new AphAreaList(new AphArea[]{new RPGArea(200.0f, this.getColor())}).setOnlyVision(false).executeClient(player.getLevel(), player.x, player.y);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 20000;
    }

    @Override
    public int getCooldownModPerLevel() {
        return -3600;
    }
}

