/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import aphorea.registry.AphModifiers;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills.Smite;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGModifiers;

public class LightInfusion
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(8.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(10.0f, false);
    }

    public LightInfusion(int levelMax, int requiredClassLevel) {
        super("lightinfusion", "#ffff66", levelMax, requiredClassLevel);
    }

    @Override
    public void runServer(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runServer(player, playerData, activeSkillLevel, seed, isInUse);
        RPGBuffs.applyStop((Mob)player, 300);
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.glyphTrapCharge, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(0.5f));
        player.getLevel().entityManager.addParticle((Particle)new Smite.SmiteParticle(player.getLevel(), player.x, player.y, 300L), Particle.GType.CRITICAL);
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new ActiveSkillBuff(){

            @Override
            public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
                int level = this.getLevel(activeBuff);
                activeBuff.setModifier(AphModifiers.MAGIC_HEALING, (Object)Float.valueOf((float)level * 0.2f));
                activeBuff.setModifier(RPGModifiers.HOLY_DAMAGE, (Object)Float.valueOf((float)level * 0.2f));
            }

            public void clientTick(ActiveBuff activeBuff) {
                Mob owner = activeBuff.owner;
                if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
                    owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(LightInfusion.this.getColor()).height(16.0f);
                }
            }
        };
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f) + 300;
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 14000;
    }
}

