/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.PlayerClasses.Cleric.ActiveSkills;

import aphorea.registry.AphModifiers;
import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.LinkedList;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.MobExtraDrawBuff;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import rpgclasses.buffs.Skill.ActiveSkillBuff;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleBuffActiveSkill;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.utils.RPGUtils;

public class HolyGuard
extends SimpleBuffActiveSkill {
    public static SkillParam[] params = new SkillParam[]{new SkillParam("6 x <skilllevel>"), new SkillParam("10 x <skilllevel>")};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    @Override
    public SkillParam getManaParam() {
        return SkillParam.manaParam(20.0f, false);
    }

    public HolyGuard(int levelMax, int requiredClassLevel) {
        super("holyguard", "#ffff00", levelMax, requiredClassLevel);
    }

    @Override
    public void giveBuffOnRun(PlayerMob player, PlayerData playerData, int activeSkillLevel) {
        super.giveBuff(player, (Mob)player, activeSkillLevel);
        GameUtils.streamServerClients((Level)player.getLevel()).forEach(targetPlayer -> {
            if (targetPlayer.isSameTeam(player.getTeam())) {
                super.giveBuff(player, (Mob)targetPlayer.playerMob, activeSkillLevel);
            }
        });
        RPGUtils.streamMobsAndPlayers((Mob)player, 200).filter(m -> m == player || m.isSameTeam((Mob)player)).forEach(target -> super.giveBuff(player, (Mob)target, activeSkillLevel));
    }

    @Override
    public void runClient(PlayerMob player, PlayerData playerData, int activeSkillLevel, int seed, boolean isInUse) {
        super.runClient(player, playerData, activeSkillLevel, seed, isInUse);
        SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((float)player.x, (float)player.y).volume(2.0f).pitch(1.0f));
        AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea(200.0f, new Color[]{this.getColor()})}).setOnlyVision(false);
        areaList.executeClient(player.getLevel(), player.x, player.y);
    }

    @Override
    public int getDuration(int activeSkillLevel) {
        return (int)(params[0].value() * 1000.0f);
    }

    @Override
    public int getBaseCooldown(PlayerMob player) {
        return 30000;
    }

    @Override
    public ActiveSkillBuff getBuff() {
        return new HolyBuff();
    }

    public class HolyBuff
    extends ActiveSkillBuff
    implements MobExtraDrawBuff {
        public GameTexture starBarrierTexture;

        @Override
        public void loadTextures() {
            super.loadTextures();
            this.starBarrierTexture = GameTexture.fromFile((String)"particles/starbarrier");
        }

        @Override
        public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
            int level = this.getLevel(activeBuff);
            activeBuff.setModifier(AphModifiers.MAGIC_HEALING_RECEIVED, (Object)Float.valueOf(params[1].value(level)));
        }

        public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
            super.onBeforeHitCalculated(activeBuff, event);
            if (!event.isPrevented()) {
                event.prevent();
                event.showDamageTip = false;
                event.playHitSound = false;
                activeBuff.owner.buffManager.removeBuff(activeBuff.buff, true);
            }
        }

        public void addBackDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        }

        public void addFrontDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (perspective == null) {
                return;
            }
            if (activeBuff.getGndData().getBoolean("ready")) {
                Rectangle selectBox = activeBuff.owner.getSelectBox(x, y);
                int size = Math.max(selectBox.width, selectBox.height);
                int modX = size - selectBox.width;
                int modY = size - selectBox.height;
                int drawX = camera.getDrawX((float)selectBox.x - (float)modX / 2.0f);
                int drawY = camera.getDrawY((float)selectBox.y - (float)modY / 2.0f);
                list.add((DrawOptions)this.starBarrierTexture.initDraw().sprite((int)(perspective.getLocalTime() / 100L) % 4, 0, 64).size(size, size).color(HolyGuard.this.getColor()).pos(drawX, drawY).alpha(0.6f));
            }
        }
    }
}

