/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.LoadedMod;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import rpgclasses.content.player.PlayerClasses.Cleric.ClericPlayerClass;
import rpgclasses.content.player.PlayerClasses.Druid.DruidPlayerClass;
import rpgclasses.content.player.PlayerClasses.Necromancer.NecromancerPlayerClass;
import rpgclasses.content.player.PlayerClasses.Ranger.RangerPlayerClass;
import rpgclasses.content.player.PlayerClasses.Warrior.WarriorPlayerClass;
import rpgclasses.content.player.PlayerClasses.Wizard.WizardPlayerClass;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.content.player.SkillsLogic.SkillsList;
import rpgclasses.content.player.UpcomingPlayerClass;
import rpgclasses.data.PlayerData;
import rpgclasses.settings.RPGSettings;

public class PlayerClass {
    public static Map<String, PlayerClass> classes = new HashMap<String, PlayerClass>();
    public static List<PlayerClass> classesList = new ArrayList<PlayerClass>();
    public final int id = classes.size();
    public final String stringID;
    public final String color;
    public final SkillsList<ActiveSkill> activeSkillsList;
    public final SkillsList<Passive> passivesList;
    public GameTexture texture;
    public GameTexture textureDisabled;
    public LoadedMod mod;

    public static void registerCore() {
        PlayerClass.registerClass(new WarriorPlayerClass());
        PlayerClass.registerClass(new RangerPlayerClass());
        PlayerClass.registerClass(new WizardPlayerClass());
        PlayerClass.registerClass(new NecromancerPlayerClass());
        PlayerClass.registerClass(new ClericPlayerClass());
        PlayerClass.registerClass(new UpcomingPlayerClass("rogue", "#8B0000"));
        PlayerClass.registerClass(new UpcomingPlayerClass("warlock", "#B22222"));
        PlayerClass.registerClass(new DruidPlayerClass());
    }

    public static void registerClass(PlayerClass playerClass) {
        classes.put(playerClass.stringID, playerClass);
        classesList.add(playerClass);
        if (!(playerClass instanceof UpcomingPlayerClass)) {
            RPGSettings.addClassSetting(playerClass);
        }
        playerClass.activeSkillsList.each(activeSkill -> {
            activeSkill.playerClass = playerClass;
        });
        playerClass.passivesList.each(activeSkill -> {
            activeSkill.playerClass = playerClass;
        });
    }

    public PlayerClass(String stringID, String color) {
        this.stringID = stringID;
        this.color = color;
        this.activeSkillsList = this.initActiveSkillsList();
        this.passivesList = this.initPassivesList();
        this.mod = LoadedMod.getRunningMod();
    }

    public void initResources() {
        this.texture = GameTexture.fromFile((String)("classes/" + this.stringID));
        this.textureDisabled = GameTexture.fromFile((String)("classes/" + this.stringID + "_disabled"));
    }

    public ListGameTooltips getToolTips() {
        boolean enabled = this.isEnabled();
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"classes", (String)this.stringID) + " \u00a70- " + this.mod.name);
        if (!enabled) {
            tooltips.add(" ");
            tooltips.add(Localization.translate((String)"ui", (String)"disabledclass"));
        }
        if (enabled) {
            tooltips.add(" ");
            tooltips.add(Localization.translate((String)"ui", (String)"clicktoopen"));
        }
        return tooltips;
    }

    public int getLevel(PlayerData playerData) {
        return playerData.getClassLevel(this.id);
    }

    public int totalPassivePoints(int level) {
        return level * 2;
    }

    public int totalActiveSkillPoints(int level) {
        return level;
    }

    public boolean isEnabled() {
        return RPGSettings.classEnabled(this);
    }

    protected SkillsList<ActiveSkill> initActiveSkillsList() {
        return new SkillsList<ActiveSkill>();
    }

    protected SkillsList<Passive> initPassivesList() {
        return new SkillsList<Passive>();
    }

    public GameTexture getTexture() {
        return this.isEnabled() ? this.texture : this.textureDisabled;
    }
}

