/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.Mastery.MasterySkills;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.LinkedList;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.MobExtraDrawBuff;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.buffs.Skill.MasteryBuff;
import rpgclasses.buffs.Skill.SecondaryMasteryBuff;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.packets.PacketMobResetBuffTime;

public class IronInvoker
extends Mastery {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(5.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public IronInvoker(String stringID, String color) {
        super(stringID, color);
    }

    @Override
    public MasteryBuff masteryBuff() {
        return null;
    }

    @Override
    public SecondaryMasteryBuff secondaryMasteryBuff() {
        return new SummonMagicShieldBuff();
    }

    public static class SummonMagicShieldBuff
    extends SecondaryMasteryBuff
    implements MobExtraDrawBuff {
        public GameTexture starBarrierTexture;

        @Override
        public void loadTextures() {
            super.loadTextures();
            this.starBarrierTexture = GameTexture.fromFile((String)"particles/starbarrier");
        }

        @Override
        public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
            activeBuff.getGndData().setBoolean("ready", true);
        }

        public void serverTick(ActiveBuff activeBuff) {
            super.serverTick(activeBuff);
            if (!activeBuff.getGndData().getBoolean("ready")) {
                int time = activeBuff.getGndData().getInt("time", 0);
                if ((time += 50) >= (int)(params[0].value() * 1000.0f)) {
                    activeBuff.getGndData().setBoolean("ready", true);
                }
                activeBuff.getGndData().setInt("time", time);
            }
        }

        public void clientTick(ActiveBuff activeBuff) {
            super.serverTick(activeBuff);
            if (!activeBuff.getGndData().getBoolean("ready")) {
                int time = activeBuff.getGndData().getInt("time", 0);
                if (time == 0) {
                    SoundManager.playSound((GameSound)GameResources.shatter2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(1.0f).pitch(0.8f));
                }
                if ((time += 50) >= (int)(params[0].value() * 1000.0f)) {
                    activeBuff.getGndData().setBoolean("ready", true);
                    SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(0.5f));
                    SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(0.5f));
                }
                activeBuff.getGndData().setInt("time", time);
            }
        }

        public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
            super.onBeforeHitCalculated(activeBuff, event);
            if (activeBuff.getGndData().getBoolean("ready") && !event.isPrevented()) {
                event.prevent();
                event.showDamageTip = false;
                event.playHitSound = false;
                activeBuff.getGndData().setBoolean("ready", false);
                activeBuff.getGndData().setInt("time", 0);
                activeBuff.owner.getServer().network.sendToClientsAtEntireLevel((Packet)new PacketMobResetBuffTime(activeBuff.owner.getUniqueID(), activeBuff.buff.getStringID()), activeBuff.owner.getLevel());
            }
        }

        public void addBackDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        }

        public void addFrontDrawOptions(ActiveBuff activeBuff, LinkedList<DrawOptions> list, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
            if (perspective == null) {
                return;
            }
            if (activeBuff.getGndData().getBoolean("ready")) {
                Rectangle selectBox = activeBuff.owner.getSelectBox(x, y);
                int size = Math.max(selectBox.width, selectBox.height);
                int modX = size - selectBox.width;
                int modY = size - selectBox.height;
                int drawX = camera.getDrawX((float)selectBox.x - (float)modX / 2.0f);
                int drawY = camera.getDrawY((float)selectBox.y - (float)modY / 2.0f);
                list.add((DrawOptions)this.starBarrierTexture.initDraw().sprite((int)(perspective.getLocalTime() / 100L) % 4, 0, 64).size(size, size).color(new Color(102, 102, 102)).pos(drawX, drawY).alpha(0.6f));
            }
        }
    }
}

