/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.Mastery.MasterySkills;

import necesse.engine.registries.MobRegistry;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobHealthChangeEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.level.maps.Level;
import rpgclasses.buffs.Skill.MasteryBuff;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.content.player.SkillsLogic.Params.SkillParam;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.summons.damageable.DamageableFollowingMob;

public class DarkEminence
extends Mastery {
    public static SkillParam[] params = new SkillParam[]{SkillParam.staticParam(15.0f).setDecimals(2, 0), SkillParam.staticParam(3.0f)};

    @Override
    public SkillParam[] getParams() {
        return params;
    }

    public DarkEminence(String stringID, String color) {
        super(stringID, color);
    }

    @Override
    public MasteryBuff masteryBuff() {
        return new MasteryBuff(){

            public void onBeforeHitCalculated(ActiveBuff activeBuff, MobBeforeHitCalculatedEvent event) {
                PlayerMob player;
                int maxDamage;
                int excess;
                Mob attacker;
                super.onBeforeHitCalculated(activeBuff, event);
                if (activeBuff.owner.isServer() && activeBuff.owner.isPlayer && (attacker = event.attacker.getAttackOwner()) != null && (excess = event.damage - (maxDamage = Math.max(1, (int)((float)(player = (PlayerMob)activeBuff.owner).getMaxHealth() * 0.15f)))) > 0) {
                    long lastUse = activeBuff.getGndData().getLong("lastUse");
                    long now = player.getTime();
                    if (lastUse + (long)((int)(params[0].value() * 1000.0f)) > now) {
                        return;
                    }
                    activeBuff.getGndData().setLong("lastUse", now);
                    event.prevent();
                    event.showDamageTip = false;
                    event.playHitSound = false;
                    player.getLevel().entityManager.events.add((LevelEvent)new MobHealthChangeEvent((Mob)player, -maxDamage));
                    DamageableFollowingMob mob = (DamageableFollowingMob)MobRegistry.getMob((String)"necromancerskeletonwarrior", (Level)player.getLevel());
                    player.serverFollowersManager.addFollower(DarkEminence.this.stringID, (Mob)mob, FollowPosition.WALK_CLOSE, null, 1.0f, Integer.MAX_VALUE, null, true);
                    PlayerData playerData = PlayerDataList.getPlayerData(player);
                    mob.updateStats(player, playerData);
                    player.getLevel().entityManager.addMob((Mob)mob, player.x, player.y);
                    player.getLevel().entityManager.events.add((LevelEvent)new MobHealthChangeEvent((Mob)mob, -excess));
                }
            }
        };
    }

    @Override
    public String[] getExtraTooltips() {
        return new String[]{"necromancerskeletonwarrior"};
    }
}

