/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player.Mastery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.buffs.Skill.MasteryBuff;
import rpgclasses.buffs.Skill.PrincipalPassiveBuff;
import rpgclasses.buffs.Skill.SecondaryMasteryBuff;
import rpgclasses.buffs.Skill.SecondaryPassiveBuff;
import rpgclasses.content.player.Mastery.FlatMastery;
import rpgclasses.content.player.Mastery.MasterySkills.Barbarian;
import rpgclasses.content.player.Mastery.MasterySkills.Bastion;
import rpgclasses.content.player.Mastery.MasterySkills.Berserker;
import rpgclasses.content.player.Mastery.MasterySkills.BloodBorn;
import rpgclasses.content.player.Mastery.MasterySkills.Chronomancer;
import rpgclasses.content.player.Mastery.MasterySkills.DarkEminence;
import rpgclasses.content.player.Mastery.MasterySkills.FrostWeaver;
import rpgclasses.content.player.Mastery.MasterySkills.Hunter;
import rpgclasses.content.player.Mastery.MasterySkills.IronInvoker;
import rpgclasses.content.player.Mastery.MasterySkills.Shapeshifter;
import rpgclasses.content.player.Mastery.MasterySkills.Sniper;
import rpgclasses.content.player.Mastery.MasterySkills.StormCaller;
import rpgclasses.content.player.Mastery.MasterySkills.Timekeeper;
import rpgclasses.content.player.Mastery.MasterySkills.Trapper;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.data.PlayerData;

public abstract class Mastery
extends SimpleBuffPassive {
    public static Map<String, Mastery> masterySkills = new HashMap<String, Mastery>();
    public static List<Mastery> masterySkillsList = new ArrayList<Mastery>();
    public static Mastery CHRONOMANCER;
    public static Mastery MARKSMAN;
    public static Mastery HUNTER;
    public static Mastery PYROMANCER;
    public static Mastery IRON_INVOKER;
    public static Mastery PLAGUE_BEARER;
    public static Mastery INQUISITOR;
    public LoadedMod mod;

    public static void registerCore() {
        Mastery.registerMastery(new Bastion("bastion", "#cccc66"));
        Mastery.registerMastery(new BloodBorn("bloodborn", "#990000"));
        CHRONOMANCER = Mastery.registerMastery(new Chronomancer("chronomancer", "#00ffff"));
        Mastery.registerMastery(new Barbarian("barbarian", "#ff6600"));
        Mastery.registerMastery(new Berserker("berserker", "#ff0000"));
        Mastery.registerMastery(new Sniper("sniper", "#ff0000"));
        MARKSMAN = Mastery.registerMastery(new FlatMastery("marksman", "#00ff00", new String[0]));
        HUNTER = Mastery.registerMastery(new Hunter("hunter", "#00cc00", "constrained"));
        Mastery.registerMastery(new Trapper("trapper", "#009900"));
        PYROMANCER = Mastery.registerMastery(new FlatMastery("pyromancer", "#ff3300", new String[0]));
        Mastery.registerMastery(new FrostWeaver("frostweaver", "#00ffff"));
        Mastery.registerMastery(new StormCaller("stormcaller", "#ffff00"));
        IRON_INVOKER = Mastery.registerMastery(new IronInvoker("ironinvoker", "#666666"));
        PLAGUE_BEARER = Mastery.registerMastery(new FlatMastery("plaguebearer", "#336633", new String[0]));
        Mastery.registerMastery(new DarkEminence("darkeminence", "#663333"));
        INQUISITOR = Mastery.registerMastery(new FlatMastery("inquisitor", "#ffcc00", new String[0]));
        Mastery.registerMastery(new Timekeeper("timekeeper", "#ffff00"));
        Mastery.registerMastery(new Shapeshifter("shapeshifter", "#ff99ff"));
    }

    public static Mastery registerMastery(Mastery mastery) {
        masterySkills.put(mastery.stringID, mastery);
        masterySkillsList.add(mastery);
        return mastery;
    }

    public Mastery(String stringID, String color) {
        super(stringID, color, 1, 0, Localization.translate((String)"masterydesc", (String)stringID).contains("[["));
        this.id = masterySkillsList.size();
        this.mod = LoadedMod.getRunningMod();
    }

    @Override
    public void initResources() {
        this.texture = GameTexture.fromFile((String)("mastery/" + this.stringID));
    }

    @Override
    public List<String> getToolTipsText(PlayerMob player) {
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"mastery", (String)this.stringID) + " \u00a70- " + this.mod.name);
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"masterydesc", (String)this.stringID));
        return tooltips;
    }

    public boolean hasMastery(PlayerData playerData) {
        return playerData.hasMasterySkill(this.id);
    }

    @Override
    public PrincipalPassiveBuff getBuff() {
        return this.masteryBuff();
    }

    @Override
    public SecondaryPassiveBuff getSecondaryBuff() {
        return this.secondaryMasteryBuff();
    }

    @Override
    public String buffsStringID() {
        return "masterybuff";
    }

    public abstract MasteryBuff masteryBuff();

    public SecondaryMasteryBuff secondaryMasteryBuff() {
        return null;
    }

    public void giveMasteryBuff(Mob target) {
        String buffStringID = this.getBuffStringID();
        if (BuffRegistry.getBuff((String)buffStringID) == null) {
            return;
        }
        ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)buffStringID), target, 1000, null);
        target.buffManager.addBuff(ab, target.isServer());
    }
}

