/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content.player;

import aphorea.registry.AphModifiers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.modifiers.Modifier;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.gfx.gameTexture.GameTexture;
import rpgclasses.content.player.SkillsLogic.ModifierBuffs.FloatModifierBuff;
import rpgclasses.content.player.SkillsLogic.ModifierBuffs.FloatPercentModifierBuff;
import rpgclasses.content.player.SkillsLogic.ModifierBuffs.IntModifierBuff;
import rpgclasses.content.player.SkillsLogic.ModifierBuffs.ModifierBuff;
import rpgclasses.content.player.SkillsLogic.Passives.BasicPassive;
import rpgclasses.data.PlayerData;
import rpgclasses.registry.RPGModifiers;

public class Attribute
extends BasicPassive {
    public static Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    public static List<Attribute> attributesList = new ArrayList<Attribute>();
    public Modifier<Integer> ownModifier;
    public String[] extraTooltips;
    public LoadedMod mod;

    public static void registerCore() {
        Attribute.registerAttribute(new Attribute("endurance", "#4682B4", RPGModifiers.ENDURANCE_ATTR_FLAT, new IntModifierBuff((Modifier<Integer>)BuffModifiers.MAX_HEALTH_FLAT, 3), new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.ARMOR, 0.02f), new FloatModifierBuff((Modifier<Float>)BuffModifiers.COMBAT_HEALTH_REGEN_FLAT, 0.15f)));
        Attribute.registerAttribute(new Attribute("speed", "#FFD60A", RPGModifiers.SPEED_ATTR_FLAT, new String[]{"dodgechance"}, new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.SPEED, 0.02f), new FloatPercentModifierBuff(RPGModifiers.DODGE_CHANCE, 0.005f)));
        Attribute.registerAttribute(new Attribute("strength", "#D94F30", RPGModifiers.STRENGTH_ATTR_FLAT, new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.MELEE_DAMAGE, 0.01f), new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.RANGED_DAMAGE, 0.01f), new IntModifierBuff((Modifier<Integer>)BuffModifiers.MAX_HEALTH_FLAT, 2)));
        Attribute.registerAttribute(new Attribute("intelligence", "#9D4EDD", RPGModifiers.INTELLIGENCE_ATTR_FLAT, new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.MAGIC_DAMAGE, 0.01f), new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.SUMMON_DAMAGE, 0.01f), new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.COMBAT_MANA_REGEN, 0.05f)));
        Attribute.registerAttribute(new Attribute("grace", "#2ECC71", RPGModifiers.GRACE_ATTR_FLAT, new String[]{"holydamage"}, new FloatPercentModifierBuff((Modifier<Float>)AphModifiers.MAGIC_HEALING, 0.02f), new FloatPercentModifierBuff((Modifier<Float>)BuffModifiers.LIFE_ESSENCE_GAIN, 0.02f), new FloatPercentModifierBuff(RPGModifiers.HOLY_DAMAGE, 0.01f)));
    }

    public static void registerAttribute(Attribute attribute) {
        attributes.put(attribute.stringID, attribute);
        attributesList.add(attribute);
    }

    public static Attribute getRandom() {
        return (Attribute)GameRandom.globalRandom.getOneOf(attributesList);
    }

    public Attribute(String stringID, String color, Modifier<Integer> ownModifier, String[] extraTooltips, ModifierBuff<?> ... modifierBuffs) {
        super(stringID, color, 0, 0, modifierBuffs);
        this.id = attributes.size();
        this.ownModifier = ownModifier;
        this.extraTooltips = extraTooltips;
        this.mod = LoadedMod.getRunningMod();
    }

    public Attribute(String stringID, String color, Modifier<Integer> ownModifier, ModifierBuff<?> ... modifierBuffs) {
        this(stringID, color, ownModifier, new String[0], modifierBuffs);
    }

    @Override
    public void initResources() {
        this.texture = GameTexture.fromFile((String)("attributes/" + this.stringID));
    }

    @Override
    public List<String> getToolTipsText(PlayerMob player) {
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("\u00a7" + this.color + Localization.translate((String)"attributes", (String)this.stringID) + " \u00a70- " + this.mod.name);
        tooltips.add(" ");
        tooltips.add(Localization.translate((String)"ui", (String)"eachlevel"));
        tooltips.add(" ");
        for (ModifierBuff attributeModifier : this.attributeModifiers) {
            tooltips.add(attributeModifier.getTooltip());
        }
        return tooltips;
    }

    public float getLevel(PlayerData playerData, PlayerMob player) {
        return playerData.getAttribute(this.id, player);
    }
}

