/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import rpgclasses.buffs.MobClasses.BossMobClassBuff;
import rpgclasses.buffs.MobClasses.DarkMobClassBuff;
import rpgclasses.buffs.MobClasses.ExplosiveMobClassBuff;
import rpgclasses.buffs.MobClasses.FlashMobClassBuff;
import rpgclasses.buffs.MobClasses.GlacialMobClassBuff;
import rpgclasses.buffs.MobClasses.HealerMobClassBuff;
import rpgclasses.buffs.MobClasses.LegendMobClassBuff;
import rpgclasses.buffs.MobClasses.MobClassBuff;
import rpgclasses.buffs.MobClasses.RunnerMobClassBuff;
import rpgclasses.buffs.MobClasses.TankMobClassBuff;
import rpgclasses.buffs.MobClasses.WarriorMobClassBuff;
import rpgclasses.data.MobData;
import rpgclasses.settings.RPGSettings;

public class MobClass {
    public static Map<String, MobClass> allClasses = new HashMap<String, MobClass>();
    public static ArrayList<MobClass> allClassesList = new ArrayList();
    public static MobClass bossClass;
    public static List<MobClass> basicClasses;
    public static List<MobClass> uncommonClasses;
    public static List<MobClass> rareClasses;
    public static List<MobClass> mythicClasses;
    public final int id = allClasses.size();
    public final String stringID;
    public final String color;
    public final float healthModPerLevel;
    public final float expMod;
    public final Class<? extends MobClassBuff> classBuff;
    public MobClassBuff buff;

    public static void registerCore() {
        MobClass.registerBossClass(new MobClass("boss", "0", 0.04f, RPGSettings.bossKillBonus(), BossMobClassBuff.class));
        MobClass.registerMobClass(basicClasses, new MobClass("warrior", "#993333", 0.02f, WarriorMobClassBuff.class));
        MobClass.registerMobClass(basicClasses, new MobClass("tank", "#666666", 0.02f, TankMobClassBuff.class));
        MobClass.registerMobClass(basicClasses, new MobClass("runner", "#339966", 0.02f, RunnerMobClassBuff.class));
        MobClass.registerMobClass(uncommonClasses, new MobClass("healer", "#00ff00", 0.02f, 1.2f, HealerMobClassBuff.class));
        MobClass.registerMobClass(uncommonClasses, new MobClass("explosive", "#ff0000", 0.02f, 1.2f, ExplosiveMobClassBuff.class));
        MobClass.registerMobClass(uncommonClasses, new MobClass("glacial", "#00ffff", 0.02f, 1.2f, GlacialMobClassBuff.class));
        MobClass.registerMobClass(rareClasses, new MobClass("flash", "#ffff00", 0.02f, 2.0f, FlashMobClassBuff.class));
        MobClass.registerMobClass(rareClasses, new MobClass("dark", "#000000", 0.02f, 2.0f, DarkMobClassBuff.class));
        MobClass.registerMobClass(mythicClasses, new MobClass("legend", "#ff6600", 0.02f, 5.0f, LegendMobClassBuff.class));
    }

    public static void registerBossClass(MobClass mobClass) {
        bossClass = mobClass;
        MobClass.registerMobClass(mobClass);
    }

    public static void registerMobClass(List<MobClass> classList, MobClass mobClass) {
        classList.add(mobClass);
        MobClass.registerMobClass(mobClass);
    }

    public static void registerMobClass(MobClass mobClass) {
        allClasses.put(mobClass.stringID, mobClass);
        allClassesList.add(mobClass);
        try {
            mobClass.buff = (MobClassBuff)BuffRegistry.registerBuff((String)mobClass.buffStringID(), (Buff)mobClass.classBuff.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static MobClass getRandomClass(GameRandom random) {
        int randomN = random.getIntBetween(0, 999);
        List<MobClass> list = randomN < 5 ? mythicClasses : (randomN < 55 ? rareClasses : (randomN < 205 ? uncommonClasses : basicClasses));
        return MobClass.getRandomClass(random, list);
    }

    public static MobClass getRandomClass(GameRandom random, List<MobClass> list) {
        return list.get(random.getIntBetween(0, list.size() - 1));
    }

    public MobClass(String stringID, String color, float healthModPerLevel, float expMod, Class<? extends MobClassBuff> classBuff) {
        this.stringID = stringID;
        this.color = color;
        this.healthModPerLevel = healthModPerLevel;
        this.expMod = expMod;
        this.classBuff = classBuff;
    }

    public MobClass(String stringID, String color, float healthModPerLevel, Class<? extends MobClassBuff> classBuff) {
        this(stringID, color, healthModPerLevel, 1.0f, classBuff);
    }

    public String getName() {
        return Localization.translate((String)"mobclass", (String)this.stringID);
    }

    public void initBuffs(Mob mob, int classLevel) {
        int maxHealth = (int)((float)mob.getMaxHealth() * (1.0f + this.healthModPerLevel * (float)MobData.levelScaling(classLevel)) * (1.0f + this.buff.healthBoost()));
        mob.setMaxHealth(maxHealth);
        mob.setHealthHidden(maxHealth);
        ActiveBuff ab = new ActiveBuff((Buff)this.buff, mob, 3600.0f, null);
        MobClassBuff.setMobLevel(ab, classLevel);
        mob.buffManager.addBuff(ab, false);
    }

    public String buffStringID() {
        return this.stringID + "mobclassbuff";
    }

    public boolean is(String stringID) {
        return Objects.equals(this.stringID, stringID);
    }

    static {
        basicClasses = new ArrayList<MobClass>();
        uncommonClasses = new ArrayList<MobClass>();
        rareClasses = new ArrayList<MobClass>();
        mythicClasses = new ArrayList<MobClass>();
    }
}

