/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;

public class ModResets
extends ModularChatCommand {
    public ModResets() {
        super("modresets", "Add or remove Reset Points from a player", PermissionLevel.ADMIN, true, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler(true, false), true, new CmdParameter[0]), new CmdParameter("amount", (ParameterHandler)new IntParameterHandler(), false, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog commandLog) {
        String author = serverClient != null ? serverClient.playerMob.getDisplayName() : "Unknown";
        ServerClient target = (ServerClient)args[0];
        if (target == null) {
            if (serverClient != null) {
                target = serverClient;
            } else {
                commandLog.add("Error: No player specified and no client context available. (Author: " + author + ")");
                return;
            }
        }
        int amount = (Integer)args[1];
        PlayerMob player = target.playerMob;
        PlayerData playerData = PlayerDataList.getPlayerData(player);
        int previousResets = playerData.getResets();
        playerData.modResetsSendPacket(target, amount);
        commandLog.add(String.format("%s's Reset Points modified by %d (%d -> %d) by %s", player.getDisplayName(), amount, previousResets, playerData.getResets(), author));
    }
}

