/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs;

import java.awt.Color;
import java.util.Objects;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.ActiveSkill;
import rpgclasses.content.player.SkillsLogic.ActiveSkills.SimpleTranformationActiveSkill;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.registry.RPGModifiers;

public class TransformingBuff
extends Buff {
    public ParticleTypeSwitcher particleTypeSwitcher;

    public TransformingBuff() {
        this.isImportant = true;
        this.canCancel = false;
        this.particleTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL});
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        activeBuff.addModifier(BuffModifiers.SPEED, (Object)Float.valueOf(-0.75f));
        activeBuff.addModifier(BuffModifiers.INTIMIDATED, (Object)true);
        activeBuff.addModifier(RPGModifiers.NO_SKILLS, (Object)true);
    }

    public void onWasHit(ActiveBuff activeBuff, MobWasHitEvent event) {
        super.onWasHit(activeBuff, event);
        if (event.damage > 0 && !event.wasPrevented && activeBuff.owner.isPlayer) {
            PlayerMob player = (PlayerMob)activeBuff.owner;
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            playerData.removeInUseActiveSkillSlot();
            player.buffManager.removeBuff(this.getID(), false);
        }
    }

    public void onRemoved(ActiveBuff activeBuff) {
        super.onRemoved(activeBuff);
        if (activeBuff.owner.isPlayer && activeBuff.owner.mount == -1) {
            if (activeBuff.owner.isServer()) {
                PlayerData playerData;
                ActiveSkill equippedActiveSkill;
                PlayerMob player = (PlayerMob)activeBuff.owner;
                int transformationType = activeBuff.getGndData().getInt("transformationType");
                String transformation = activeBuff.getGndData().getString("transformation");
                if (transformationType == 0 && (equippedActiveSkill = (playerData = PlayerDataList.getPlayerData(player)).getInUseActiveSkill()) instanceof SimpleTranformationActiveSkill && Objects.equals(equippedActiveSkill.stringID, transformation)) {
                    ((SimpleTranformationActiveSkill)equippedActiveSkill).transform(player);
                }
            }
            if (activeBuff.owner.isClient()) {
                SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)activeBuff.owner).volume(0.35f).pitch(1.0f));
            }
        }
    }

    public void clientTick(ActiveBuff activeBuff) {
        int guaranteed;
        float chance = 2.0f - (float)activeBuff.getDurationLeft() / (float)activeBuff.getDuration() * 2.0f;
        int times = guaranteed + (GameRandom.globalRandom.getChance(chance - (float)(guaranteed = (int)chance)) ? 1 : 0);
        for (int i = 0; i < times; ++i) {
            Color color = new Color(activeBuff.getGndData().getInt("particlesColor"));
            int angle = (int)(360.0f + GameRandom.globalRandom.nextFloat() * 360.0f);
            float dx = (float)Math.sin(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            float dy = (float)Math.cos(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
            float variation = GameRandom.globalRandom.getFloatOffset(1.0f, 0.2f);
            activeBuff.owner.getLevel().entityManager.addParticle(activeBuff.owner.x - dx + activeBuff.owner.dx, activeBuff.owner.y - dy + activeBuff.owner.dy, this.particleTypeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(new Color(GameMath.limit((int)((int)((float)color.getRed() * variation)), (int)0, (int)255), GameMath.limit((int)((int)((float)color.getGreen() * variation)), (int)0, (int)255), GameMath.limit((int)((int)((float)color.getBlue() * variation)), (int)0, (int)255), color.getAlpha())).heightMoves(10.0f, 20.0f, 5.0f, 0.0f, 10.0f, 0.0f).lifeTime(250);
        }
    }
}

