/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.Passive;

import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import rpgclasses.buffs.Passive.PassiveBuff;
import rpgclasses.content.player.SkillsLogic.Passives.BasicPassive;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.mobs.mount.TransformationMountMob;

public class TransformedBuff
extends PassiveBuff {
    public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
        PlayerMob player = null;
        if (activeBuff.owner instanceof PlayerMob) {
            player = (PlayerMob)activeBuff.owner;
        } else if (activeBuff.owner.getRider() instanceof PlayerMob) {
            player = (PlayerMob)activeBuff.owner.getRider();
        }
        if (player != null) {
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            for (PlayerClassData classData : playerData.getClassesData()) {
                for (int i = 0; i < classData.getPassiveLevels().length; ++i) {
                    Passive passive;
                    int passiveLevel = classData.getPassiveLevels()[i];
                    if (passiveLevel <= 0 || !((passive = classData.playerClass.passivesList.get(i)) instanceof BasicPassive)) continue;
                    BasicPassive basicPassive = (BasicPassive)passive;
                    if (!basicPassive.onlyTransformed) continue;
                    basicPassive.applyBuff(activeBuff, passiveLevel);
                }
            }
        }
    }

    public void onBeforeHit(ActiveBuff activeBuff, MobBeforeHitEvent event) {
        super.onBeforeHit(activeBuff, event);
        if (!activeBuff.owner.isPlayer) {
            return;
        }
        Mob mount2 = activeBuff.owner.getMount();
        if (mount2 instanceof TransformationMountMob) {
            ((TransformationMountMob)mount2).onBeforeHit((PlayerMob)activeBuff.owner, event);
        }
    }

    public void serverTick(ActiveBuff activeBuff) {
        super.serverTick(activeBuff);
        if (activeBuff.owner instanceof TransformationMountMob) {
            return;
        }
        if (!(activeBuff.owner.getMount() instanceof TransformationMountMob)) {
            activeBuff.remove();
        }
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        if (activeBuff.owner instanceof TransformationMountMob) {
            return;
        }
        if (!(activeBuff.owner.getMount() instanceof TransformationMountMob)) {
            activeBuff.remove();
        }
    }
}

