/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.Passive;

import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import rpgclasses.buffs.Interfaces.DodgeClassBuff;
import rpgclasses.buffs.MarkedBuff;
import rpgclasses.buffs.Passive.PassiveBuff;
import rpgclasses.content.player.Attribute;
import rpgclasses.content.player.SkillsLogic.Passives.BasicPassive;
import rpgclasses.content.player.SkillsLogic.Passives.Passive;
import rpgclasses.data.PlayerClassData;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.ShowDodgePacket;
import rpgclasses.registry.RPGModifiers;

public class ModifiersBuff
extends PassiveBuff {
    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        if (activeBuff.owner.isPlayer) {
            PlayerMob player = (PlayerMob)activeBuff.owner;
            new ModifierValue(RPGModifiers.THROWING_DAMAGE, (Object)Float.valueOf((((Float)player.buffManager.getModifier(BuffModifiers.MELEE_DAMAGE)).floatValue() + ((Float)player.buffManager.getModifier(BuffModifiers.RANGED_DAMAGE)).floatValue()) * 0.5f)).apply((ModifierContainer)activeBuff);
            new ModifierValue(RPGModifiers.THROWING_ATTACK_SPEED, (Object)Float.valueOf((((Float)player.buffManager.getModifier(BuffModifiers.MELEE_ATTACK_SPEED)).floatValue() + ((Float)player.buffManager.getModifier(BuffModifiers.RANGED_ATTACK_SPEED)).floatValue()) * 0.5f)).apply((ModifierContainer)activeBuff);
            new ModifierValue(RPGModifiers.THROWING_CRIT_CHANCE, (Object)Float.valueOf((((Float)player.buffManager.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue() + ((Float)player.buffManager.getModifier(BuffModifiers.RANGED_CRIT_CHANCE)).floatValue()) * 0.5f)).apply((ModifierContainer)activeBuff);
            new ModifierValue(RPGModifiers.THROWING_CRIT_DAMAGE, (Object)Float.valueOf((((Float)player.buffManager.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue() + ((Float)player.buffManager.getModifier(BuffModifiers.RANGED_CRIT_CHANCE)).floatValue()) * 0.5f)).apply((ModifierContainer)activeBuff);
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            if (playerData != null) {
                for (Attribute attribute : Attribute.attributesList) {
                    float attributeLevel = attribute.getLevel(playerData, player);
                    if (!(attributeLevel > 0.0f)) continue;
                    attribute.applyBuff(activeBuff, attributeLevel);
                }
                for (PlayerClassData classesDatum : playerData.getClassesData()) {
                    for (int i = 0; i < classesDatum.getPassiveLevels().length; ++i) {
                        Passive passive;
                        int passiveLevel = classesDatum.getPassiveLevels()[i];
                        if (passiveLevel <= 0 || !((passive = classesDatum.playerClass.passivesList.get(i)) instanceof BasicPassive)) continue;
                        BasicPassive basicPassive = (BasicPassive)passive;
                        if (basicPassive.onlyTransformed) continue;
                        basicPassive.applyBuff(activeBuff, passiveLevel);
                    }
                }
            }
        }
    }

    public void onHasAttacked(ActiveBuff activeBuff, MobWasHitEvent event) {
        float focusChance;
        super.onHasAttacked(activeBuff, event);
        if (event.damage > 0 && !event.wasPrevented && event.attacker.getAttackOwner() == activeBuff.owner && ((focusChance = ((Float)activeBuff.owner.buffManager.getModifier(RPGModifiers.FOCUS_CHANCE)).floatValue()) >= 1.0f || focusChance > 0.0f && GameRandom.globalRandom.getChance(focusChance))) {
            MarkedBuff.markMob((PlayerMob)activeBuff.owner, event.target, 5000);
        }
    }

    public void onBeforeHit(ActiveBuff activeBuff, MobBeforeHitEvent event) {
        super.onBeforeHit(activeBuff, event);
        if (this.preventDamage(activeBuff, event)) {
            event.prevent();
            event.showDamageTip = false;
            event.playHitSound = false;
        }
    }

    private boolean preventDamage(ActiveBuff activeBuff, MobBeforeHitEvent event) {
        String prevent = this.shouldPreventDamage(activeBuff, event);
        if (prevent != null && activeBuff.owner.isServer()) {
            if (prevent.equals("dodge")) {
                activeBuff.owner.getServer().network.sendToClientsAtEntireLevel((Packet)new ShowDodgePacket(activeBuff.owner.getX(), activeBuff.owner.getY()), activeBuff.owner.getLevel());
                List dodgeClassBuffs = activeBuff.owner.buffManager.getBuffs().values().stream().filter(ab -> ab.buff instanceof DodgeClassBuff).collect(Collectors.toList());
                for (ActiveBuff ab2 : dodgeClassBuffs) {
                    ((DodgeClassBuff)ab2.buff).onDodge(ab2, event);
                }
            }
            return true;
        }
        return false;
    }

    public String shouldPreventDamage(ActiveBuff activeBuff, MobBeforeHitEvent event) {
        float reduceChance = Math.min(1.0f, ((Float)activeBuff.owner.buffManager.getModifier(BuffModifiers.SPEED)).floatValue());
        if (event.attacker.getAttackOwner() != null && GameRandom.globalRandom.getChance(((Float)activeBuff.owner.buffManager.getModifier(RPGModifiers.DODGE_CHANCE)).floatValue() * reduceChance)) {
            return "dodge";
        }
        return null;
    }
}

