/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.Passive;

import aphorea.utils.magichealing.AphMagicHealingBuff;
import java.text.DecimalFormat;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobHealthChangeEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rpgclasses.buffs.Passive.PassiveBuff;
import rpgclasses.data.MobData;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGDamageType;

public class HolyDamageDealtBuff
extends PassiveBuff
implements AphMagicHealingBuff {
    public HolyDamageDealtBuff() {
        this.isVisible = true;
        this.isImportant = true;
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
        this.isVisible = false;
    }

    public void serverTick(ActiveBuff activeBuff) {
        super.serverTick(activeBuff);
        float used = HolyDamageDealtBuff.getUsedDamageDealt(activeBuff);
        if (used > 0.0f) {
            HolyDamageDealtBuff.setUsedDamageDealt(activeBuff, 0.0f);
            HolyDamageDealtBuff.addDamageDealt(activeBuff, -used, true);
        } else {
            float damageDealt = HolyDamageDealtBuff.getDamageDealt(activeBuff);
            if (damageDealt >= 0.01f) {
                HolyDamageDealtBuff.addDamageDealt(activeBuff, -damageDealt / 100.0f, true);
            }
        }
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        this.isVisible = HolyDamageDealtBuff.getDamageDealt(activeBuff) >= 0.01f;
    }

    public void onHasAttacked(ActiveBuff activeBuff, MobWasHitEvent event) {
        super.onHasAttacked(activeBuff, event);
        float holyDamage = (float)event.damage * 0.02f;
        if (holyDamage > 0.0f && !event.wasPrevented && event.damageType == RPGDamageType.HOLY) {
            HolyDamageDealtBuff.addDamageDealt(activeBuff, holyDamage, true);
            Mob target = event.target;
            if (MobData.isWeakToHoly(target, activeBuff.owner)) {
                if (event.damage >= 100) {
                    target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.ABLAZE, target, 5.0f, (Attacker)activeBuff.owner), activeBuff.owner.isServer());
                } else {
                    target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.ON_FIRE, target, 10.0f, (Attacker)activeBuff.owner), activeBuff.owner.isServer());
                }
            }
        }
    }

    public void onMagicalHealing(ActiveBuff activeBuff, Mob healer, Mob target, int healing, int realHealing, @Nullable ToolItem toolItem, @Nullable InventoryItem item) {
        int extraHeal = (int)Math.min((float)(target.getMaxHealth() - target.getHealth()), HolyDamageDealtBuff.getDamageDealt(activeBuff));
        if (extraHeal > 0) {
            target.getLevel().entityManager.events.add((LevelEvent)new MobHealthChangeEvent(target, extraHeal));
            HolyDamageDealtBuff.addUsedDamageDealt(activeBuff, extraHeal);
        }
    }

    public void drawIcon(int x, int y, ActiveBuff activeBuff) {
        GameTexture drawIcon2 = this.getDrawIcon(activeBuff);
        drawIcon2.initDraw().size(32, 32).draw(x, y);
        float numberDisplay = HolyDamageDealtBuff.getDamageDealt(activeBuff);
        if (numberDisplay > 0.0f) {
            String text = HolyDamageDealtBuff.getString(numberDisplay);
            int width = FontManager.bit.getWidthCeil(text, durationFontOptions);
            FontManager.bit.drawString((float)(x + 28 - width), (float)(y + 30 - FontManager.bit.getHeightCeil(text, durationFontOptions)), text, durationFontOptions);
        }
    }

    @NotNull
    private static String getString(double numberDisplay) {
        String postN = "";
        if (numberDisplay >= 1000000.0) {
            numberDisplay /= 1000000.0;
            postN = "M";
        } else if (numberDisplay >= 1000.0) {
            numberDisplay /= 1000.0;
            postN = "K";
        }
        DecimalFormat oneDecimal = new DecimalFormat("0.0");
        String text = oneDecimal.format(numberDisplay) + postN;
        if (text.length() > 4) {
            text = "999" + postN;
        }
        return text;
    }

    public static ActiveBuff getActiveBuff(Mob mob) {
        return mob.buffManager.getBuff((Buff)RPGBuffs.PASSIVES.HOLY_DAMAGE);
    }

    public static void addDamageDealt(ActiveBuff activeBuff, float amount, boolean sendPacket) {
        if (activeBuff != null) {
            HolyDamageDealtBuff.setDamageDealt(activeBuff, HolyDamageDealtBuff.getDamageDealt(activeBuff) + amount, sendPacket);
        }
    }

    public static void setDamageDealt(ActiveBuff activeBuff, float amount, boolean sendPacket) {
        if (activeBuff != null) {
            float set = Math.max(0.0f, amount);
            activeBuff.getGndData().setFloat("damageDealt", set);
            if (sendPacket && activeBuff.owner.isPlayer && activeBuff.owner.isServer()) {
                PlayerMob player = (PlayerMob)activeBuff.owner;
                player.getServerClient().sendPacket((Packet)new ModClientHolyDamageDealtPacket(set));
            }
        }
    }

    public static float getDamageDealt(ActiveBuff activeBuff) {
        if (activeBuff != null) {
            return activeBuff.getGndData().getFloat("damageDealt", 0.0f);
        }
        return 0.0f;
    }

    public static void addUsedDamageDealt(ActiveBuff activeBuff, float amount) {
        if (activeBuff != null) {
            HolyDamageDealtBuff.setUsedDamageDealt(activeBuff, HolyDamageDealtBuff.getUsedDamageDealt(activeBuff) + amount);
        }
    }

    public static void setUsedDamageDealt(ActiveBuff activeBuff, float amount) {
        if (activeBuff != null) {
            activeBuff.getGndData().setFloat("usedDamageDealt", Math.max(0.0f, amount));
        }
    }

    public static float getUsedDamageDealt(ActiveBuff activeBuff) {
        if (activeBuff != null) {
            return activeBuff.getGndData().getFloat("usedDamageDealt", 0.0f);
        }
        return 0.0f;
    }

    public static class ModClientHolyDamageDealtPacket
    extends Packet {
        public final float amount;

        public ModClientHolyDamageDealtPacket(byte[] data) {
            super(data);
            PacketReader reader = new PacketReader((Packet)this);
            this.amount = reader.getNextFloat();
        }

        public ModClientHolyDamageDealtPacket(float amount) {
            this.amount = amount;
            PacketWriter writer = new PacketWriter((Packet)this);
            writer.putNextFloat(amount);
        }

        public void processClient(NetworkPacket packet, Client client) {
            ActiveBuff ab = HolyDamageDealtBuff.getActiveBuff((Mob)client.getPlayer());
            HolyDamageDealtBuff.setDamageDealt(ab, this.amount, false);
        }
    }
}

