/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.Passive;

import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.modifiers.ModifierValue;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.HumanDrawBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.gameObject.GameObject;
import rpgclasses.buffs.Passive.PassiveBuff;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.registry.RPGBuffs;

public class GrabbedObjectBuff
extends PassiveBuff
implements HumanDrawBuff {
    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        activeBuff.addModifier(BuffModifiers.INTIMIDATED, (Object)true);
        new ModifierValue(BuffModifiers.SPEED, (Object)Float.valueOf(-0.75f)).max((Object)Float.valueOf(0.5f)).apply((ModifierContainer)activeBuff);
        new ModifierValue(BuffModifiers.SPEED_FLAT).max((Object)Float.valueOf(0.0f)).apply((ModifierContainer)activeBuff);
        new ModifierValue(BuffModifiers.STAMINA_REGEN, (Object)Float.valueOf(((Float)activeBuff.owner.buffManager.getModifier(BuffModifiers.STAMINA_CAPACITY)).floatValue() - 1.0f)).apply((ModifierContainer)activeBuff);
        new ModifierValue(BuffModifiers.STAMINA_CAPACITY).max((Object)Float.valueOf(1.0f)).apply((ModifierContainer)activeBuff);
    }

    public void addHumanDraw(ActiveBuff activeBuff, HumanDrawOptions drawOptions) {
        if (activeBuff.owner.buffManager.hasBuff((Buff)RPGBuffs.PASSIVES.GRABBED_OBJECT) && activeBuff.owner.isPlayer) {
            PlayerMob playerMob = (PlayerMob)activeBuff.owner;
            PlayerData playerData = PlayerDataList.getPlayerData(playerMob);
            if (playerData.grabbedObject != null) {
                GameObject gameObject = playerData.grabbedObject;
                drawOptions.addTopDraw((player, dir, spriteX, spriteY, spriteRes, drawX, drawY, width, height, mirrorX, mirrorY, light, alpha, mask) -> {
                    GameSprite sprite = gameObject.getObjectItem().getWorldItemSprite(new InventoryItem((Item)gameObject.getObjectItem()), player);
                    int spriteWidth = sprite.width * 2;
                    int spriteHeight = sprite.height * 2;
                    return sprite.initDraw().size(spriteWidth, spriteHeight).light(light).pos(drawX + width / 2 - spriteWidth / 2, drawY + height / 2 - spriteHeight / 2 - 32);
                });
            }
        }
    }
}

